/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.Optional;
import javax.ws.rs.core.MediaType;
import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreatePortalManifest;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.http.SignatureHttpClientFactory;
import no.digipost.signature.client.portal.JaxbEntityMapping;
import no.digipost.signature.client.portal.PortalJob;
import no.digipost.signature.client.portal.PortalJobResponse;
import no.digipost.signature.client.portal.PortalJobStatusChanged;

public class PortalClient {
    private final ClientHelper client;
    private final CreateASiCE<PortalJob> aSiCECreator;
    private final ClientConfiguration clientConfiguration;

    public PortalClient(ClientConfiguration config) {
        this.clientConfiguration = config;
        this.client = new ClientHelper(SignatureHttpClientFactory.create(config), config.getGlobalSender());
        this.aSiCECreator = new CreateASiCE<PortalJob>(new CreatePortalManifest(config.getClock()), config);
    }

    public PortalJobResponse create(PortalJob job) {
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLPortalSignatureJobRequest signatureJobRequest = JaxbEntityMapping.toJaxb(job, this.clientConfiguration.getGlobalSender());
        XMLPortalSignatureJobResponse xmlPortalSignatureJobResponse = this.client.sendPortalSignatureJobRequest(signatureJobRequest, documentBundle, job.getSender());
        return JaxbEntityMapping.fromJaxb(xmlPortalSignatureJobResponse);
    }

    public PortalJobStatusChanged getStatusChange() {
        return this.getStatusChange(null);
    }

    public PortalJobStatusChanged getStatusChange(Sender sender) {
        JobStatusResponse<XMLPortalSignatureJobStatusChangeResponse> statusChangeResponse = this.client.getPortalStatusChange(Optional.ofNullable(sender));
        if (statusChangeResponse.gotStatusChange()) {
            return JaxbEntityMapping.fromJaxb(statusChangeResponse);
        }
        return PortalJobStatusChanged.noUpdatedStatus(statusChangeResponse.getNextPermittedPollTime());
    }

    public void confirm(PortalJobStatusChanged receivedStatusChanged) {
        this.client.confirm(receivedStatusChanged);
    }

    public void cancel(Cancellable cancellable) {
        this.client.cancel(cancellable);
    }

    public ResponseInputStream getXAdES(XAdESReference xAdESReference) {
        return this.client.getDataStream(xAdESReference.getxAdESUrl(), MediaType.APPLICATION_XML_TYPE);
    }

    public ResponseInputStream getPAdES(PAdESReference pAdESReference) {
        return this.client.getDataStream(pAdESReference.getpAdESUrl(), MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.APPLICATION_XML_TYPE);
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        this.client.deleteDocuments(deleteDocumentsUrl);
    }
}

