/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.Optional;
import no.digipost.signature.client.core.OnBehalfOf;
import no.digipost.signature.client.core.SignatureType;
import no.digipost.signature.client.core.internal.IdentifierType;
import no.digipost.signature.client.core.internal.PersonalIdentificationNumbers;
import no.digipost.signature.client.core.internal.SignerCustomizations;
import no.digipost.signature.client.portal.Notifications;
import no.digipost.signature.client.portal.NotificationsUsingLookup;

public class PortalSigner {
    private final IdentifierType identifierType;
    private final Optional<String> identifier;
    private Notifications notifications;
    private NotificationsUsingLookup notificationsUsingLookup;
    private int order = 0;
    private Optional<SignatureType> signatureType = Optional.empty();
    private Optional<OnBehalfOf> onBehalfOf = Optional.empty();

    private PortalSigner(IdentifierType identifierType, Notifications notifications) {
        this.identifier = Optional.empty();
        this.identifierType = identifierType;
        this.notifications = notifications;
    }

    private PortalSigner(String personalIdentificationNumber, Notifications notifications, NotificationsUsingLookup notificationsUsingLookup) {
        this.identifier = Optional.of(personalIdentificationNumber);
        this.identifierType = IdentifierType.PERSONAL_IDENTIFICATION_NUMBER;
        this.notifications = notifications;
        this.notificationsUsingLookup = notificationsUsingLookup;
    }

    public static Builder identifiedByPersonalIdentificationNumber(String personalIdentificationNumber, Notifications notifications) {
        return new Builder(personalIdentificationNumber, notifications, null);
    }

    public static Builder identifiedByPersonalIdentificationNumber(String personalIdentificationNumber, NotificationsUsingLookup notificationsUsingLookup) {
        return new Builder(personalIdentificationNumber, null, notificationsUsingLookup);
    }

    public static Builder identifiedByEmail(String emailAddress) {
        return new Builder(IdentifierType.EMAIL, Notifications.builder().withEmailTo(emailAddress).build());
    }

    public static Builder identifiedByMobileNumber(String number) {
        return new Builder(IdentifierType.MOBILE_NUMBER, Notifications.builder().withSmsTo(number).build());
    }

    public static Builder identifiedByEmailAndMobileNumber(String emailAddress, String number) {
        return new Builder(IdentifierType.EMAIL_AND_MOBILE_NUMBER, Notifications.builder().withEmailTo(emailAddress).withSmsTo(number).build());
    }

    public boolean isIdentifiedByPersonalIdentificationNumber() {
        return this.identifierType == IdentifierType.PERSONAL_IDENTIFICATION_NUMBER;
    }

    public Optional<String> getIdentifier() {
        return this.identifier;
    }

    public IdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public int getOrder() {
        return this.order;
    }

    public Notifications getNotifications() {
        return this.notifications;
    }

    public NotificationsUsingLookup getNotificationsUsingLookup() {
        return this.notificationsUsingLookup;
    }

    public Optional<SignatureType> getSignatureType() {
        return this.signatureType;
    }

    public Optional<OnBehalfOf> getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public String toString() {
        return this.isIdentifiedByPersonalIdentificationNumber() ? PersonalIdentificationNumbers.mask(this.identifier.get()) : "Signer with " + this.notifications;
    }

    public static class Builder
    implements SignerCustomizations<Builder> {
        private final PortalSigner target;
        private boolean built = false;

        private Builder(String personalIdentificationNumber, Notifications notifications, NotificationsUsingLookup notificationsUsingLookup) {
            this.target = new PortalSigner(personalIdentificationNumber, notifications, notificationsUsingLookup);
        }

        private Builder(IdentifierType identifierType, Notifications notifications) {
            this.target = new PortalSigner(identifierType, notifications);
        }

        public Builder withOrder(int order) {
            this.target.order = order;
            return this;
        }

        @Override
        public Builder withSignatureType(SignatureType type) {
            this.target.signatureType = Optional.of(type);
            return this;
        }

        @Override
        public Builder onBehalfOf(OnBehalfOf onBehalfOf) {
            this.target.onBehalfOf = Optional.of(onBehalfOf);
            return this;
        }

        public PortalSigner build() {
            if (this.target.onBehalfOf.isPresent() && this.target.onBehalfOf.get() == OnBehalfOf.OTHER && this.target.notificationsUsingLookup != null) {
                throw new IllegalStateException("Can't look up contact information for notifications when signing on behalf of a third party");
            }
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

