/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import no.digipost.signature.api.xml.XMLDirectSignerStatusValue;
import no.digipost.signature.api.xml.XMLPortalSignatureStatusValue;

public final class SignatureStatus {
    private static final ConcurrentMap<XMLPortalSignatureStatusValue, SignatureStatus> KNOWN = new ConcurrentHashMap<XMLPortalSignatureStatusValue, SignatureStatus>();
    public static final SignatureStatus REJECTED = new SignatureStatus("REJECTED");
    public static final SignatureStatus CANCELLED = new SignatureStatus("CANCELLED");
    public static final SignatureStatus RESERVED = new SignatureStatus("RESERVED");
    public static final SignatureStatus CONTACT_INFORMATION_MISSING = new SignatureStatus("CONTACT_INFORMATION_MISSING");
    public static final SignatureStatus EXPIRED = new SignatureStatus("EXPIRED");
    public static final SignatureStatus WAITING = new SignatureStatus("WAITING");
    public static final SignatureStatus SIGNED = new SignatureStatus("SIGNED");
    public static final SignatureStatus NOT_APPLICABLE = new SignatureStatus("NOT_APPLICABLE");
    public static final SignatureStatus BLOCKED = new SignatureStatus("BLOCKED");
    public static final SignatureStatus SIGNERS_NAME_NOT_AVAILABLE = SignatureStatus.of(XMLPortalSignatureStatusValue.SIGNERS_NAME_NOT_AVAILABLE);
    private final String identifier;

    static final SignatureStatus of(XMLPortalSignatureStatusValue status) {
        Objects.requireNonNull(status, XMLDirectSignerStatusValue.class.getSimpleName());
        return KNOWN.computeIfAbsent(status, key -> new SignatureStatus(key.asString()));
    }

    private SignatureStatus(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (o instanceof SignatureStatus) {
            SignatureStatus that = (SignatureStatus)o;
            return Objects.equals(this.identifier, that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

