/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.digipost.signature.client.ApacheHttpClientConfigurer;
import no.digipost.signature.client.ServiceEnvironment;
import no.digipost.signature.client.TimeoutsConfigurer;
import no.digipost.signature.client.archive.ArchiveClient;
import no.digipost.signature.client.asice.ASiCEConfiguration;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.asice.DumpDocumentBundleToDisk;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.WithSignatureServiceRootUrl;
import no.digipost.signature.client.core.internal.MaySpecifySender;
import no.digipost.signature.client.core.internal.configuration.ApacheHttpClientBuilderConfigurer;
import no.digipost.signature.client.core.internal.configuration.ApacheHttpClientProxyConfigurer;
import no.digipost.signature.client.core.internal.configuration.ApacheHttpClientSslConfigurer;
import no.digipost.signature.client.core.internal.configuration.ApacheHttpClientUserAgentConfigurer;
import no.digipost.signature.client.core.internal.configuration.Configurer;
import no.digipost.signature.client.security.CertificateChainValidation;
import no.digipost.signature.client.security.KeyStoreConfig;
import no.digipost.signature.client.security.OrganizationNumberValidation;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;

public final class ClientConfiguration
implements ASiCEConfiguration,
WithSignatureServiceRootUrl,
ArchiveClient.Configuration {
    private static final Logger LOG = Logger.getLogger(ClientConfiguration.class.getName());
    private static final String JAVA_DESCRIPTION = System.getProperty("java.vendor", "unknown Java") + ", " + System.getProperty("java.version", "unknown version");
    public static final String MANDATORY_USER_AGENT = "posten-signature-api-client-java/" + ClientMetadata.VERSION + " (" + JAVA_DESCRIPTION + ")";
    private final MaySpecifySender defaultSender;
    private final URI serviceRoot;
    private final KeyStoreConfig keyStoreConfig;
    private final Configurer<HttpClientBuilder> defaultHttpClientConfigurer;
    private final Configurer<HttpClientBuilder> httpClientForDocumentDownloadsConfigurer;
    private final Iterable<DocumentBundleProcessor> documentBundleProcessors;
    private final Clock clock;

    private ClientConfiguration(MaySpecifySender defaultSender, URI serviceRoot, KeyStoreConfig keyStoreConfig, Configurer<HttpClientBuilder> defaultHttpClientConfigurer, Configurer<HttpClientBuilder> httpClientForDocumentDownloadsConfigurer, Iterable<DocumentBundleProcessor> documentBundleProcessors, Clock clock) {
        this.keyStoreConfig = keyStoreConfig;
        this.defaultSender = defaultSender;
        this.serviceRoot = serviceRoot;
        this.defaultHttpClientConfigurer = defaultHttpClientConfigurer;
        this.httpClientForDocumentDownloadsConfigurer = httpClientForDocumentDownloadsConfigurer;
        this.documentBundleProcessors = documentBundleProcessors;
        this.clock = clock;
    }

    @Override
    public KeyStoreConfig getKeyStoreConfig() {
        return this.keyStoreConfig;
    }

    @Override
    public MaySpecifySender getDefaultSender() {
        return this.defaultSender;
    }

    @Override
    public Iterable<DocumentBundleProcessor> getDocumentBundleProcessors() {
        return this.documentBundleProcessors;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public URI signatureServiceRootUrl() {
        return this.serviceRoot;
    }

    @Override
    public HttpClient httpClientForDocumentDownloads() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this.httpClientForDocumentDownloadsConfigurer.applyTo(httpClientBuilder);
        return httpClientBuilder.build();
    }

    public HttpClient defaultHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this.defaultHttpClientConfigurer.applyTo(httpClientBuilder);
        return httpClientBuilder.build();
    }

    public static Builder builder(KeyStoreConfig keystore) {
        return new Builder(keystore);
    }

    public static class Builder {
        private final KeyStoreConfig keyStoreConfig;
        final ApacheHttpClientUserAgentConfigurer userAgentConfigurer = new ApacheHttpClientUserAgentConfigurer(MANDATORY_USER_AGENT);
        private final ApacheHttpClientSslConfigurer sslConfigurer;
        private final ApacheHttpClientBuilderConfigurer defaultHttpClientConfigurer;
        private final ApacheHttpClientBuilderConfigurer httpClientForDocumentDownloadsConfigurer;
        private Configurer<HttpClientBuilder> proxyConfigurer = Configurer.notConfigured();
        private ServiceEnvironment serviceEnvironment = ServiceEnvironment.PRODUCTION;
        private MaySpecifySender defaultSender = MaySpecifySender.NO_SPECIFIED_SENDER;
        private List<DocumentBundleProcessor> documentBundleProcessors = new ArrayList<DocumentBundleProcessor>();
        private Clock clock = Clock.systemDefaultZone();

        private Builder(KeyStoreConfig keyStoreConfig) {
            this.keyStoreConfig = keyStoreConfig;
            this.sslConfigurer = new ApacheHttpClientSslConfigurer(keyStoreConfig, this.serviceEnvironment);
            this.defaultHttpClientConfigurer = new ApacheHttpClientBuilderConfigurer().connectionManager(this.sslConfigurer).socketTimeout(Duration.ofSeconds(5L)).connectTimeout(Duration.ofSeconds(5L)).connectionRequestTimeout(Duration.ofSeconds(5L)).responseArrivalTimeout(Duration.ofSeconds(10L));
            this.httpClientForDocumentDownloadsConfigurer = new ApacheHttpClientBuilderConfigurer().connectionManager(this.sslConfigurer).socketTimeout(Duration.ofSeconds(5L)).connectTimeout(Duration.ofSeconds(10L)).connectionRequestTimeout(Duration.ofSeconds(10L)).responseArrivalTimeout(Duration.ofSeconds(60L));
        }

        public Builder serviceEnvironment(ServiceEnvironment other) {
            return this.serviceEnvironment(current -> other);
        }

        public Builder serviceEnvironment(UnaryOperator<ServiceEnvironment> updateServiceEnvironment) {
            this.serviceEnvironment = (ServiceEnvironment)updateServiceEnvironment.apply(this.serviceEnvironment);
            this.sslConfigurer.trust(this.serviceEnvironment);
            return this;
        }

        public Builder httpProxyHost(String hostname, int port) {
            return this.proxyHost(URI.create(hostname + ":" + port));
        }

        public Builder proxyHost(URI proxyHostUri) {
            this.proxyConfigurer = new ApacheHttpClientProxyConfigurer(HttpHost.create((URI)proxyHostUri));
            return this;
        }

        public Builder defaultSender(Sender sender) {
            this.defaultSender = MaySpecifySender.specifiedAs(sender);
            return this;
        }

        public Builder includeInUserAgent(String userAgentCustomPart) {
            this.userAgentConfigurer.append("(" + userAgentCustomPart + ")");
            return this;
        }

        public Builder timeouts(Consumer<? super TimeoutsConfigurer> timeouts) {
            timeouts.accept(this.defaultHttpClientConfigurer);
            return this;
        }

        public Builder timeoutsForDocumentDownloads(Consumer<? super TimeoutsConfigurer> timeouts) {
            timeouts.accept(this.httpClientForDocumentDownloadsConfigurer);
            return this;
        }

        public Builder apacheHttpClient(Consumer<? super ApacheHttpClientConfigurer> apacheHttpClientConfigurer) {
            apacheHttpClientConfigurer.accept(this.defaultHttpClientConfigurer);
            return this;
        }

        public Builder apacheHttpClientForDocumentDownloads(Consumer<? super ApacheHttpClientConfigurer> apacheHttpClientConfigurer) {
            apacheHttpClientConfigurer.accept(this.httpClientForDocumentDownloadsConfigurer);
            return this;
        }

        public Builder enableDocumentBundleDiskDump(Path directory) {
            return this.addDocumentBundleProcessor(new DumpDocumentBundleToDisk(directory, this.clock));
        }

        public Builder addDocumentBundleProcessor(DocumentBundleProcessor processor) {
            this.documentBundleProcessors.add(processor);
            return this;
        }

        public Builder serverOrganizationNumber(String serverOrganizationNumber) {
            return this.serverCertificateTrustStrategy(new OrganizationNumberValidation(serverOrganizationNumber));
        }

        public Builder serverCertificateTrustStrategy(CertificateChainValidation certificateChainValidation) {
            LOG.warning("Overriding server certificate TrustStrategy! This should NOT be done for any integration with Posten signering.");
            this.sslConfigurer.certificatChainValidation(certificateChainValidation);
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public ClientConfiguration build() {
            Configurer<HttpClientBuilder> commonConfig = this.userAgentConfigurer.andThen(this.proxyConfigurer);
            return new ClientConfiguration(this.defaultSender, this.serviceEnvironment.signatureServiceRootUrl(), this.keyStoreConfig, commonConfig.andThen(this.defaultHttpClientConfigurer), commonConfig.andThen(this.httpClientForDocumentDownloadsConfigurer), this.documentBundleProcessors, this.clock);
        }
    }

    static final class ClientMetadata {
        static final String VERSION;

        private ClientMetadata() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            String version = "unknown version";
            try (InputStream versionFile = ClientMetadata.class.getResourceAsStream("version");
                 Scanner scanner = new Scanner(versionFile, "UTF-8");){
                version = scanner.next();
            }
            catch (Exception e) {
                Logger log = Logger.getLogger(ClientMetadata.class.getName());
                log.warning("Unable to resolve library version from classpath resource 'version', because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'" + (log.isLoggable(Level.FINE) ? "" : ". Enable debug-logging for logger '" + log.getName() + "' to see full stacktrace for this warning"));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, e, e::getMessage);
                }
            }
            finally {
                VERSION = version;
            }
        }
    }
}

