/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import no.digipost.signature.client.Certificates;
import no.digipost.signature.client.core.WithSignatureServiceRootUrl;
import no.digipost.signature.client.core.internal.security.ProvidesCertificateResourcePaths;

public final class ServiceEnvironment
implements ProvidesCertificateResourcePaths,
WithSignatureServiceRootUrl {
    public static final ServiceEnvironment PRODUCTION = new ServiceEnvironment("Posten signering Production", URI.create("https://api.signering.posten.no/api"), Certificates.PRODUCTION.certificatePaths);
    public static final ServiceEnvironment DIFITEST = new ServiceEnvironment("Posten signering Difitest", URI.create("https://api.difitest.signering.posten.no/api"), Certificates.TEST.certificatePaths);
    public static final ServiceEnvironment DIFIQA = new ServiceEnvironment("Posten signering Difiqa", URI.create("https://api.difiqa.signering.posten.no/api"), Certificates.TEST.certificatePaths);
    public static final ServiceEnvironment STAGING = DIFITEST.withDescription("Posten signering Staging");
    private final String description;
    private final URI serviceRootUrl;
    private final List<String> certificatePaths;

    public ServiceEnvironment(String description, URI serviceRootUrl, Collection<String> certificatePaths) {
        this.description = description;
        this.serviceRootUrl = serviceRootUrl;
        this.certificatePaths = Collections.unmodifiableList(new ArrayList<String>(certificatePaths));
    }

    public ServiceEnvironment withDescription(String description) {
        return new ServiceEnvironment(description, this.serviceRootUrl, this.certificatePaths);
    }

    public ServiceEnvironment withServiceUrl(URI url) {
        return new ServiceEnvironment(this.description, url, this.certificatePaths);
    }

    public ServiceEnvironment withAdditionalCertificates(String ... additionalCertificatePaths) {
        return this.withAdditionalCertificates(Arrays.asList(additionalCertificatePaths));
    }

    public ServiceEnvironment withAdditionalCertificates(Collection<String> additionalCertificatePaths) {
        ArrayList<String> allCertificatePaths = new ArrayList<String>(this.certificatePaths);
        allCertificatePaths.addAll(additionalCertificatePaths);
        return this.withCertificates(allCertificatePaths);
    }

    public ServiceEnvironment withCertificates(String ... certificatePaths) {
        return this.withCertificates(Arrays.asList(certificatePaths));
    }

    public ServiceEnvironment withCertificates(Collection<String> certificatePaths) {
        return new ServiceEnvironment(this.description, this.serviceRootUrl, certificatePaths);
    }

    @Override
    public URI signatureServiceRootUrl() {
        return this.serviceRootUrl;
    }

    @Override
    public List<String> certificatePaths() {
        return this.certificatePaths;
    }

    public String toString() {
        return this.description + " at " + this.serviceRootUrl + ", trusting " + this.certificatePaths;
    }
}

