/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.manifest;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.stream.Collectors;
import no.digipost.signature.api.xml.XMLAuthenticationLevel;
import no.digipost.signature.api.xml.XMLAvailability;
import no.digipost.signature.api.xml.XMLEmail;
import no.digipost.signature.api.xml.XMLEnabled;
import no.digipost.signature.api.xml.XMLHref;
import no.digipost.signature.api.xml.XMLIdentifierInSignedDocuments;
import no.digipost.signature.api.xml.XMLNotifications;
import no.digipost.signature.api.xml.XMLNotificationsUsingLookup;
import no.digipost.signature.api.xml.XMLPortalDocument;
import no.digipost.signature.api.xml.XMLPortalSignatureJobManifest;
import no.digipost.signature.api.xml.XMLPortalSigner;
import no.digipost.signature.api.xml.XMLSender;
import no.digipost.signature.api.xml.XMLSignatureType;
import no.digipost.signature.api.xml.XMLSigningOnBehalfOf;
import no.digipost.signature.api.xml.XMLSms;
import no.digipost.signature.client.asice.manifest.ManifestCreator;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.OnBehalfOf;
import no.digipost.signature.client.core.SignatureType;
import no.digipost.signature.client.core.exceptions.SignerNotSpecifiedException;
import no.digipost.signature.client.core.internal.MaySpecifySender;
import no.digipost.signature.client.portal.Notifications;
import no.digipost.signature.client.portal.NotificationsUsingLookup;
import no.digipost.signature.client.portal.PortalJob;
import no.digipost.signature.client.portal.PortalSigner;

public class CreatePortalManifest
extends ManifestCreator<PortalJob> {
    private final MaySpecifySender defaultSenderConfiguration;
    private final Clock clock;

    public CreatePortalManifest(MaySpecifySender defaultSenderConfiguration, Clock clock) {
        this.defaultSenderConfiguration = defaultSenderConfiguration;
        this.clock = clock;
    }

    XMLPortalSignatureJobManifest buildXmlManifest(PortalJob job) {
        ArrayList<XMLPortalSigner> xmlSigners = new ArrayList<XMLPortalSigner>();
        for (PortalSigner signer : job.getSigners()) {
            XMLPortalSigner xmlPortalSigner = this.generateSigner(signer);
            if (signer.getNotifications() != null) {
                xmlPortalSigner.setNotifications(this.generateNotifications(signer.getNotifications()));
            } else if (signer.getNotificationsUsingLookup() != null) {
                xmlPortalSigner.setNotificationsUsingLookup(this.generateNotificationsUsingLookup(signer.getNotificationsUsingLookup()));
            }
            xmlSigners.add(xmlPortalSigner);
        }
        ZonedDateTime activationTime = job.getActivationTime().map(activation -> activation.atZone(this.clock.getZone())).orElse(null);
        return new XMLPortalSignatureJobManifest().withSigners(xmlSigners).withRequiredAuthentication((XMLAuthenticationLevel)job.getRequiredAuthentication().map(AuthenticationLevel::getXmlEnumValue).orElse(null)).withSender(new XMLSender().withOrganizationNumber(job.resolveSenderWithFallbackTo(this.defaultSenderConfiguration, new MaySpecifySender[0]).getOrganizationNumber())).withTitle(job.getTitle()).withNonsensitiveTitle((String)job.getNonsensitiveTitle().orElse(null)).withDescription((String)job.getDescription().orElse(null)).withDocuments(job.getDocuments().stream().map(document -> new XMLPortalDocument().withTitle(document.getTitle()).withHref(XMLHref.of((String)document.getFileName())).withMediaType(document.getMediaType())).collect(Collectors.toList())).withAvailability(new XMLAvailability().withActivationTime(activationTime).withAvailableSeconds((Long)job.getAvailable().map(Duration::getSeconds).orElse(null))).withIdentifierInSignedDocuments((XMLIdentifierInSignedDocuments)job.getIdentifierInSignedDocuments().map(IdentifierInSignedDocuments::getXmlEnumValue).orElse(null));
    }

    private XMLPortalSigner generateSigner(PortalSigner signer) {
        XMLPortalSigner xmlSigner = new XMLPortalSigner().withOrder(Integer.valueOf(signer.getOrder())).withSignatureType((XMLSignatureType)signer.getSignatureType().map(SignatureType::getXmlEnumValue).orElse(null)).withOnBehalfOf((XMLSigningOnBehalfOf)signer.getOnBehalfOf().map(OnBehalfOf::getXmlEnumValue).orElse(null));
        if (signer.isIdentifiedByPersonalIdentificationNumber()) {
            xmlSigner.setPersonalIdentificationNumber(signer.getIdentifier().orElseThrow(SignerNotSpecifiedException.SIGNER_NOT_SPECIFIED));
        } else {
            xmlSigner.setIdentifiedByContactInformation(new XMLEnabled());
        }
        return xmlSigner;
    }

    private XMLNotificationsUsingLookup generateNotificationsUsingLookup(NotificationsUsingLookup notificationsUsingLookup) {
        XMLNotificationsUsingLookup xmlNotificationsUsingLookup = new XMLNotificationsUsingLookup();
        if (notificationsUsingLookup.shouldSendEmail) {
            xmlNotificationsUsingLookup.setEmail(new XMLEnabled());
        }
        if (notificationsUsingLookup.shouldSendSms) {
            xmlNotificationsUsingLookup.setSms(new XMLEnabled());
        }
        return xmlNotificationsUsingLookup;
    }

    private XMLNotifications generateNotifications(Notifications notifications) {
        XMLNotifications xmlNotifications = new XMLNotifications();
        if (notifications.shouldSendEmail()) {
            xmlNotifications.setEmail(new XMLEmail().withAddress(notifications.getEmailAddress()));
        }
        if (notifications.shouldSendSms()) {
            xmlNotifications.setSms(new XMLSms().withNumber(notifications.getMobileNumber()));
        }
        return xmlNotifications;
    }
}

