/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import no.digipost.signature.client.asice.signature.CreateXAdESArtifacts;
import no.digipost.signature.client.asice.signature.DomUtils;
import no.digipost.signature.client.asice.signature.SignableFileReference;
import no.digipost.signature.client.asice.signature.Signature;
import no.digipost.signature.client.asice.signature.XAdESArtifacts;
import no.digipost.signature.client.asice.signature.XmlSignatureProviders;
import no.digipost.signature.client.core.exceptions.ConfigurationException;
import no.digipost.signature.client.core.exceptions.XmlConfigurationException;
import no.digipost.signature.client.core.exceptions.XmlValidationException;
import no.digipost.signature.client.security.KeyStoreConfig;
import no.digipost.signature.jaxb.JaxbMarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CreateSignature {
    private static final String C14V1 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String ASIC_NAMESPACE = "http://uri.etsi.org/2918/v1.2.1#";
    private static final String SIGNED_PROPERTIES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    private final DigestMethod sha256DigestMethod;
    private final CanonicalizationMethod canonicalizationMethod;
    private final Transform canonicalXmlTransform;
    private final DomUtils domUtils = new DomUtils();
    private final CreateXAdESArtifacts createXAdESArtifacts;
    private final Schema schema;

    public CreateSignature(Clock clock) {
        this.createXAdESArtifacts = new CreateXAdESArtifacts(clock);
        XMLSignatureFactory xmlSignatureFactory = XmlSignatureProviders.getSignatureFactory();
        try {
            this.sha256DigestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            this.canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod(C14V1, (C14NMethodParameterSpec)null);
            this.canonicalXmlTransform = xmlSignatureFactory.newTransform(C14V1, (TransformParameterSpec)null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ConfigurationException("Failed to initialize XML-signing", e);
        }
        this.schema = this.loadSchema();
    }

    private static InputSource createInputSource(String resource) {
        InputSource inputSource;
        block9: {
            URL resourceUrl = Objects.requireNonNull(JaxbMarshaller.class.getResource(resource), resource);
            InputStream inputStream = resourceUrl.openStream();
            try {
                int readLen;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int bufLen = 1024;
                byte[] buf = new byte[1024];
                while ((readLen = inputStream.read(buf, 0, 1024)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                InputSource source = new InputSource(new ByteArrayInputStream(outputStream.toByteArray()));
                source.setSystemId(resourceUrl.toString());
                inputSource = source;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to resolve " + resource + " from " + resourceUrl + ", because " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
                }
            }
            inputStream.close();
        }
        return inputSource;
    }

    private static Schema createSchema(Collection<String> resources) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser saxParser = parserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            Source[] schemaSources = (Source[])resources.stream().map(resource -> new SAXSource(xmlReader, CreateSignature.createInputSource(resource))).toArray(Source[]::new);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(schemaSources);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create schema from resources [" + String.join((CharSequence)", ", resources) + "]", e);
        }
    }

    private Schema loadSchema() {
        return CreateSignature.createSchema(new HashSet<String>(Arrays.asList("/thirdparty/xmldsig-core-schema.xsd", "/thirdparty/ts_102918v010201.xsd")));
    }

    public Signature createSignature(List<? extends SignableFileReference> attachedFiles, KeyStoreConfig keyStoreConfig) {
        return new Signature(this.domUtils.serializeToXml(this.createXmlSignature(attachedFiles, keyStoreConfig)));
    }

    protected Document createXmlSignature(List<? extends SignableFileReference> attachedFiles, KeyStoreConfig keyStoreConfig) {
        XMLSignatureFactory xmlSignatureFactory = XmlSignatureProviders.getSignatureFactory();
        SignatureMethod signatureMethod = CreateSignature.getSignatureMethod(xmlSignatureFactory);
        XAdESArtifacts xadesArtifacts = this.createXAdESArtifacts.createArtifactsToSign(attachedFiles, keyStoreConfig.getCertificate());
        List<Reference> references = this.references(xmlSignatureFactory, attachedFiles);
        references.add(xmlSignatureFactory.newReference(xadesArtifacts.signablePropertiesReferenceUri, this.sha256DigestMethod, Collections.singletonList(this.canonicalXmlTransform), SIGNED_PROPERTIES_TYPE, null));
        KeyInfo keyInfo = CreateSignature.keyInfo(xmlSignatureFactory, keyStoreConfig.getCertificateChain());
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(this.canonicalizationMethod, signatureMethod, references);
        XMLObject xmlObject = xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(xadesArtifacts.document.getDocumentElement())), null, null, null);
        XMLSignature xmlSignature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xmlObject), "Signature", null);
        Document signedDocument = this.domUtils.newEmptyXmlDocument();
        DOMSignContext signContext = new DOMSignContext(keyStoreConfig.getPrivateKey(), (Node)CreateSignature.addXAdESSignaturesElement(signedDocument));
        signContext.setURIDereferencer(this.signedPropertiesURIDereferencer(xadesArtifacts, xmlSignatureFactory));
        try {
            xmlSignature.sign(signContext);
        }
        catch (MarshalException e) {
            throw new XmlConfigurationException("failed to read ASiC-E XML for signing", e);
        }
        catch (XMLSignatureException e) {
            throw new XmlConfigurationException("Failed to sign ASiC-E element.", e);
        }
        try {
            this.schema.newValidator().validate(new DOMSource(signedDocument));
        }
        catch (IOException | SAXException e) {
            throw new XmlValidationException("Failed to validate generated signature.xml because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'. Verify that the input is valid and that there are no illegal symbols in file names etc.", e);
        }
        return signedDocument;
    }

    private URIDereferencer signedPropertiesURIDereferencer(XAdESArtifacts xadesArtifacts, XMLSignatureFactory signatureFactory) {
        return (uriReference, context) -> {
            if (xadesArtifacts.signablePropertiesReferenceUri.equals(uriReference.getURI())) {
                return this.domUtils.allNodesBelow(xadesArtifacts.signableProperties)::iterator;
            }
            return signatureFactory.getURIDereferencer().dereference(uriReference, context);
        };
    }

    private static Element addXAdESSignaturesElement(Document doc) {
        return (Element)doc.appendChild(doc.createElementNS(ASIC_NAMESPACE, "XAdESSignatures"));
    }

    private static SignatureMethod getSignatureMethod(XMLSignatureFactory xmlSignatureFactory) {
        try {
            return xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ConfigurationException("Failed to initialize XML-signing", e);
        }
    }

    private List<Reference> references(XMLSignatureFactory xmlSignatureFactory, List<? extends SignableFileReference> files) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (int i = 0; i < files.size(); ++i) {
            try {
                String signatureElementId = "ID_" + i;
                SignableFileReference file = files.get(i);
                String uri = URLEncoder.encode(file.getFileName(), "UTF-8");
                Reference reference = xmlSignatureFactory.newReference(uri, this.sha256DigestMethod, null, null, signatureElementId, file.getSha256());
                result.add(reference);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static KeyInfo keyInfo(XMLSignatureFactory xmlSignatureFactory, Certificate[] sertifikater) {
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Arrays.asList(sertifikater));
        return keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
    }
}

