/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.exceptions;

import java.util.Objects;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.client.core.exceptions.SignatureException;
import no.digipost.signature.client.core.internal.http.StatusCode;

public class UnexpectedResponseException
extends SignatureException {
    private final XMLError error;
    private final int httpStatusCode;

    public UnexpectedResponseException(StatusCode actual) {
        this(null, actual, new StatusCode[0]);
    }

    public UnexpectedResponseException(Object errorEntity, StatusCode actual, StatusCode ... expected) {
        this(errorEntity, (Throwable)null, actual, expected);
    }

    public UnexpectedResponseException(Object errorEntity, Throwable cause, StatusCode actual, StatusCode ... expected) {
        super("Expected " + UnexpectedResponseException.prettyprintExpectedStatuses(expected) + ", but got " + actual.value() + (errorEntity != null ? " [" + errorEntity + "]" : "") + (cause != null ? " - " + cause.getClass().getSimpleName() + ": '" + cause.getMessage() + "'." : ""), cause);
        this.error = errorEntity instanceof XMLError ? (XMLError)errorEntity : null;
        this.httpStatusCode = actual.value();
    }

    public boolean isHttpStatusCode(int statusCode) {
        return this.httpStatusCode == statusCode;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorCode() {
        return this.error != null ? this.error.getErrorCode() : null;
    }

    public String getErrorMessage() {
        return this.error != null ? this.error.getErrorMessage() : null;
    }

    public String getErrorType() {
        return this.error != null ? this.error.getErrorType() : null;
    }

    public boolean isErrorCode(String errorCode) {
        return this.error != null && Objects.equals(this.error.getErrorCode(), errorCode);
    }

    private static String prettyprintExpectedStatuses(StatusCode ... statuses) {
        if (statuses == null || statuses.length == 0) {
            return "status not specified";
        }
        String message = "[" + UnexpectedResponseException.prettyprintSingleStatus(statuses[0]);
        for (int i = 1; i < statuses.length; ++i) {
            message = message + ", " + UnexpectedResponseException.prettyprintSingleStatus(statuses[i]);
        }
        return message + "]";
    }

    private static String prettyprintSingleStatus(StatusCode status) {
        return status.value() + "";
    }
}

