/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLDirectSignerResponse;
import no.digipost.signature.api.xml.XMLDirectSignerUpdateRequest;
import no.digipost.signature.api.xml.XMLEmptyElement;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.CantQueryStatusException;
import no.digipost.signature.client.core.exceptions.DocumentsNotDeletableException;
import no.digipost.signature.client.core.exceptions.HttpIOException;
import no.digipost.signature.client.core.exceptions.InvalidStatusQueryTokenException;
import no.digipost.signature.client.core.exceptions.JobCannotBeCancelledException;
import no.digipost.signature.client.core.exceptions.NotCancellableException;
import no.digipost.signature.client.core.exceptions.TooEagerPollingException;
import no.digipost.signature.client.core.internal.ApiFlow;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientExceptionMapper;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.core.internal.ErrorCodes;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.http.ResponseStatus;
import no.digipost.signature.client.core.internal.http.SignatureServiceRoot;
import no.digipost.signature.client.core.internal.http.StatusCode;
import no.digipost.signature.client.core.internal.xml.Marshalling;
import no.digipost.signature.client.direct.WithSignerUrl;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartPartBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

public class ClientHelper {
    private static final Logger LOG = Logger.getLogger(ClientHelper.class.getName());
    private static final String NEXT_PERMITTED_POLL_TIME_HEADER = "X-Next-permitted-poll-time";
    private static final String POLLING_QUEUE_QUERY_PARAMETER = "polling_queue";
    private final SignatureServiceRoot serviceRoot;
    private final HttpClient httpClient;

    public ClientHelper(SignatureServiceRoot serviceRoot, HttpClient httpClient) {
        this.serviceRoot = serviceRoot;
        this.httpClient = httpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <RESPONSE, REQUEST> RESPONSE sendSignatureJobRequest(ApiFlow<REQUEST, RESPONSE, ?> target, REQUEST signatureJobRequest, DocumentBundle documentBundle, Sender sender) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setContentType(ContentType.MULTIPART_MIXED);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Marshalling.marshal(signatureJobRequest, os);
            multipartEntityBuilder.addPart(MultipartPartBuilder.create().setBody((ContentBody)new ByteArrayBody(os.toByteArray(), ContentType.APPLICATION_XML, "")).addHeader("Content-Type", ContentType.APPLICATION_XML.getMimeType()).build());
            multipartEntityBuilder.addPart(MultipartPartBuilder.create().setBody((ContentBody)new InputStreamBody(documentBundle.getInputStream(), ContentType.APPLICATION_OCTET_STREAM, "")).addHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.getMimeType()).build());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (HttpEntity multiPart = multipartEntityBuilder.build();){
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)this.serviceRoot.constructUrl(uri -> uri.appendPath(target.path(sender)))).addHeader("Accept", ContentType.APPLICATION_XML.getMimeType()).build();
            request.setEntity(multiPart);
            Object object = this.call(() -> {
                try {
                    return this.httpClient.execute(request, response -> ClientHelper.parseResponse(response, target.apiResponseType));
                }
                catch (IOException e) {
                    throw new HttpIOException((HttpRequest)request, e);
                }
            });
            return (RESPONSE)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public XMLDirectSignerResponse requestNewRedirectUrl(WithSignerUrl url) {
        XMLDirectSignerResponse xMLDirectSignerResponse;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Marshalling.marshal(new XMLDirectSignerUpdateRequest().withRedirectUrl(new XMLEmptyElement()), os);
            HttpPost request = new HttpPost(url.getSignerUrl());
            request.addHeader("Accept", (Object)ContentType.APPLICATION_XML.getMimeType());
            xMLDirectSignerResponse = (XMLDirectSignerResponse)this.httpClient.execute((ClassicHttpRequest)request, response -> ClientHelper.parseResponse(response, XMLDirectSignerResponse.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        os.close();
        return xMLDirectSignerResponse;
    }

    public XMLDirectSignatureJobStatusResponse sendSignatureJobStatusRequest(URI statusUrl) {
        HttpGet request = new HttpGet(statusUrl);
        request.addHeader("Accept", (Object)ContentType.APPLICATION_XML.getMimeType());
        return this.call(() -> this.lambda$sendSignatureJobStatusRequest$6((ClassicHttpRequest)request, statusUrl));
    }

    public void cancel(Cancellable cancellable) {
        if (cancellable.getCancellationUrl() == null) {
            throw new NotCancellableException();
        }
        this.postEmptyEntity(cancellable.getCancellationUrl().getUrl(), httpResponse -> ResponseStatus.fromHttpResponse((HttpResponse)httpResponse).throwIf(StatusCode.CONFLICT, status -> new JobCannotBeCancelledException((StatusCode)status, ClientExceptionMapper.extractError(httpResponse))));
    }

    public <RES> JobStatusResponse<RES> getStatusChange(ApiFlow<?, ?, RES> target, Sender sender) {
        URI jobStatusUrl = this.serviceRoot.constructUrl(uri -> uri.appendPath(target.path(sender)).addParameter(POLLING_QUEUE_QUERY_PARAMETER, sender.getPollingQueue().value));
        ClassicHttpRequest getStatusRequest = ClassicRequestBuilder.get((URI)jobStatusUrl).addHeader("Accept", ContentType.APPLICATION_XML.getMimeType()).build();
        return this.call(() -> {
            try {
                return (JobStatusResponse)this.httpClient.execute(getStatusRequest, response -> {
                    StatusCode status = ResponseStatus.fromHttpResponse((HttpResponse)response).throwIf(StatusCode.TOO_MANY_REQUESTS, s -> new TooEagerPollingException()).expect(StatusCode.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientExceptionMapper.exceptionForGeneralError(response));
                    Object statusResponseBody = status.equals(StatusCode.NO_CONTENT) ? null : (Object)Marshalling.unmarshal(response.getEntity().getContent(), target.statusResponseType);
                    return new JobStatusResponse<Object>(statusResponseBody, ClientHelper.getNextPermittedPollTime(response));
                });
            }
            catch (IOException e) {
                throw new HttpIOException((HttpRequest)getStatusRequest, e);
            }
        });
    }

    private static Instant getNextPermittedPollTime(ClassicHttpResponse response) throws ProtocolException {
        return ZonedDateTime.parse(response.getHeader(NEXT_PERMITTED_POLL_TIME_HEADER).getValue(), DateTimeFormatter.ISO_DATE_TIME).toInstant();
    }

    public void confirm(Confirmable confirmable) {
        if (confirmable.getConfirmationReference() != null) {
            URI url = confirmable.getConfirmationReference().getConfirmationUrl();
            LOG.info(() -> "Sends confirmation for '" + confirmable + "' to URL " + url);
            this.postEmptyEntity(url);
        } else {
            LOG.info(() -> "Does not need to send confirmation for '" + confirmable + "'");
        }
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        if (deleteDocumentsUrl == null) {
            throw new DocumentsNotDeletableException();
        }
        this.delete(deleteDocumentsUrl.getUrl());
    }

    private void postEmptyEntity(URI uri) {
        this.postEmptyEntity(uri, ResponseStatus::fromHttpResponse);
    }

    private void postEmptyEntity(URI uri, Function<ClassicHttpResponse, ResponseStatus> responseStatusHandling) {
        ClassicHttpRequest request = ClassicRequestBuilder.post((URI)uri).addHeader("Accept", ContentType.APPLICATION_XML.getMimeType()).build();
        this.call(() -> {
            try {
                this.httpClient.execute(request, response -> ((ResponseStatus)responseStatusHandling.apply(response)).expect(StatusCode.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientExceptionMapper.exceptionForGeneralError(response)));
            }
            catch (IOException e) {
                throw new HttpIOException((HttpRequest)request, e);
            }
        });
    }

    private void delete(URI uri) {
        ClassicHttpRequest request = ClassicRequestBuilder.delete((URI)uri).addHeader("Accept", ContentType.APPLICATION_XML.getMimeType()).build();
        this.call(() -> {
            try {
                this.httpClient.execute(request, response -> ResponseStatus.fromHttpResponse((HttpResponse)response).expect(StatusCode.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientExceptionMapper.exceptionForGeneralError(response)));
            }
            catch (IOException e) {
                throw new HttpIOException((HttpRequest)request, e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T parseResponse(ClassicHttpResponse response, Class<T> responseType) {
        ResponseStatus.fromHttpResponse((HttpResponse)response).expect(StatusCode.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientExceptionMapper.exceptionForGeneralError(response));
        try (InputStream body = response.getEntity().getContent();){
            T t = Marshalling.unmarshal(body, responseType);
            return t;
        }
        catch (IOException e) {
            throw new HttpIOException((HttpResponse)response, e);
        }
    }

    private <T> T call(Supplier<T> supplier) {
        return ClientExceptionMapper.doWithMappedClientException(supplier);
    }

    private void call(Runnable action) {
        ClientExceptionMapper.doWithMappedClientException(action);
    }

    private /* synthetic */ XMLDirectSignatureJobStatusResponse lambda$sendSignatureJobStatusRequest$6(ClassicHttpRequest request, URI statusUrl) {
        try {
            return (XMLDirectSignatureJobStatusResponse)this.httpClient.execute(request, response -> {
                ResponseStatus.fromHttpResponse((HttpResponse)response).expect(StatusCode.Family.SUCCESSFUL).orThrow(status -> {
                    XMLError error;
                    if (status.value() == 403) {
                        XMLError error2 = ClientExceptionMapper.extractError(response);
                        if (ErrorCodes.INVALID_STATUS_QUERY_TOKEN.sameAs(error2.getErrorCode())) {
                            return new InvalidStatusQueryTokenException(statusUrl, error2.getErrorMessage());
                        }
                    } else if (status.value() == 404 && ErrorCodes.SIGNING_CEREMONY_NOT_COMPLETED.sameAs((error = ClientExceptionMapper.extractError(response)).getErrorCode())) {
                        return new CantQueryStatusException((StatusCode)status, error.getErrorMessage());
                    }
                    return ClientExceptionMapper.exceptionForGeneralError(response);
                });
                return ClientHelper.parseResponse(response, XMLDirectSignatureJobStatusResponse.class);
            });
        }
        catch (IOException e) {
            throw new HttpIOException((HttpRequest)request, e);
        }
    }
}

