/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.io.IOException;
import java.net.URI;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.exceptions.HttpIOException;
import no.digipost.signature.client.core.internal.ClientExceptionMapper;
import no.digipost.signature.client.core.internal.http.SignatureServiceRoot;
import no.digipost.signature.client.core.internal.http.StatusCode;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;

public class DownloadHelper {
    private SignatureServiceRoot serviceRoot;
    private HttpClient httpClient;

    public DownloadHelper(SignatureServiceRoot serviceRoot, HttpClient httpClient) {
        this.serviceRoot = serviceRoot;
        this.httpClient = httpClient;
    }

    public ResponseInputStream getDataStream(String path, ContentType ... acceptedResponses) {
        return this.getDataStream(this.serviceRoot.constructUrl(uri -> uri.appendPath(path)), new ContentType[0]);
    }

    public ResponseInputStream getDataStream(URI absoluteUri, ContentType ... acceptedResponses) {
        if (!absoluteUri.isAbsolute()) {
            throw new IllegalArgumentException("'" + absoluteUri + "' is not an absolute URL");
        }
        HeaderGroup acceptHeader = new HeaderGroup();
        for (ContentType acceptedType : acceptedResponses) {
            acceptHeader.addHeader((Header)new BasicHeader("Accept", (Object)acceptedType.getMimeType()));
        }
        ClassicHttpRequest request = ClassicRequestBuilder.get((URI)absoluteUri).addHeader(acceptHeader.getCondensedHeader("Accept")).build();
        return ClientExceptionMapper.doWithMappedClientException(() -> {
            ClassicHttpResponse response = null;
            try {
                try {
                    response = this.httpClient.executeOpen(null, request, null);
                }
                catch (IOException e) {
                    throw new HttpIOException((HttpRequest)request, e);
                }
                StatusCode statusCode = StatusCode.from(response.getCode());
                if (!statusCode.is(StatusCode.Family.SUCCESSFUL)) {
                    throw ClientExceptionMapper.exceptionForGeneralError(response);
                }
                return new ResponseInputStream(response.getEntity().getContent(), response.getEntity().getContentLength());
            }
            catch (Exception e) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException closingException) {
                        e.addSuppressed(closingException);
                    }
                }
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(request + ": " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
            }
        });
    }
}

