/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class FileName {
    private static final Map<Pattern, String> knownReplacements = new LinkedHashMap<Pattern, String>();
    private static final char[] allowedChars;
    private static final Pattern UNICODE_ACCENT;

    public static String reduceToFileNameSafeChars(String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException(text);
        }
        String knownReplacements = text;
        for (Map.Entry<Pattern, String> replacement : FileName.knownReplacements.entrySet()) {
            knownReplacements = replacement.getKey().matcher(knownReplacements).replaceAll(replacement.getValue());
        }
        String accentsRemoved = FileName.removeAccents(knownReplacements);
        return FileName.reduceToAlphabet(accentsRemoved.toLowerCase(), allowedChars);
    }

    private static String reduceToAlphabet(String text, char[] alphabet) {
        StringBuilder reducedToAllowedChars = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            if (Arrays.binarySearch(allowedChars, c) >= 0) {
                reducedToAllowedChars.append(c);
                continue;
            }
            reducedToAllowedChars.append(allowedChars[c % allowedChars.length]);
        }
        return reducedToAllowedChars.toString();
    }

    private static String removeAccents(String text) {
        return UNICODE_ACCENT.matcher(Normalizer.normalize(text, Normalizer.Form.NFD)).replaceAll("");
    }

    private FileName() {
    }

    static {
        knownReplacements.put(Pattern.compile("[\\s:;&%\\$\\*\\?\\+=@,\\(\\)\\[\\]\\{\\}#!\"\u201c\u201d\\^`\u00b4<>]+"), "_");
        knownReplacements.put(Pattern.compile("[\u00e6\u00c6]"), "ae");
        knownReplacements.put(Pattern.compile("[\u00f8\u00d8]"), "oe");
        knownReplacements.put(Pattern.compile("[\u00e5\u00c5]"), "aa");
        allowedChars = Stream.of(IntStream.rangeClosed(48, 57), IntStream.rangeClosed(97, 122), IntStream.of(45, 95, 46)).flatMapToInt(Function.identity()).sorted().mapToObj(c -> String.valueOf((char)c)).collect(Collectors.joining()).toCharArray();
        UNICODE_ACCENT = Pattern.compile("\\p{M}");
    }
}

