/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.util.Optional;
import java.util.stream.Stream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.SenderNotSpecifiedException;
import no.digipost.signature.client.core.internal.NoSenderSpecified;
import no.digipost.signature.client.core.internal.SpecifiedSender;

public interface MaySpecifySender {
    public static final MaySpecifySender NO_SPECIFIED_SENDER = new NoSenderSpecified();

    public static MaySpecifySender specifiedAs(Sender sender) {
        return new SpecifiedSender(sender);
    }

    public static MaySpecifySender ofNullable(Sender sender) {
        return sender != null ? MaySpecifySender.specifiedAs(sender) : NO_SPECIFIED_SENDER;
    }

    public Optional<Sender> getSender();

    default public Sender resolveSenderWithFallbackTo(MaySpecifySender firstFallback, MaySpecifySender ... moreFallbacks) {
        return this.resolveSenderWithFallbackTo(moreFallbacks.length == 0 ? Stream.of(firstFallback) : Stream.concat(Stream.of(firstFallback), Stream.of(moreFallbacks)));
    }

    default public Sender resolveSenderWithFallbackTo(Stream<MaySpecifySender> fallbacks) {
        return this.getSender().orElseGet(() -> fallbacks.map(MaySpecifySender::getSender).filter(s -> s.isPresent()).findFirst().map(Optional::get).orElseThrow(SenderNotSpecifiedException::new));
    }
}

