/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.configuration;

import java.time.Duration;
import java.util.function.Consumer;
import no.digipost.signature.client.ApacheHttpClientConfigurer;
import no.digipost.signature.client.TimeoutsConfigurer;
import no.digipost.signature.client.core.internal.configuration.Configurer;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.io.SocketConfig;

public final class ApacheHttpClientBuilderConfigurer
implements TimeoutsConfigurer,
ApacheHttpClientConfigurer,
Configurer<HttpClientBuilder> {
    private final PoolingHttpClientConnectionManagerBuilder connectionManagerConfig = PoolingHttpClientConnectionManagerBuilder.create();
    private final SocketConfig.Builder socketConfig = SocketConfig.custom();
    private final ConnectionConfig.Builder connectionConfig = ConnectionConfig.custom();
    private final RequestConfig.Builder requestConfig = RequestConfig.custom();
    private final Configurer<PoolingHttpClientConnectionManagerBuilder> defaultConnectionManagerConfigurer = connectionManager -> connectionManager.setDefaultSocketConfig(this.socketConfig.build()).setDefaultConnectionConfig(this.connectionConfig.build());
    private final Configurer<HttpClientBuilder> defaultRequestConfigurer = httpClient -> httpClient.setDefaultRequestConfig(this.requestConfig.build()).setConnectionManager((HttpClientConnectionManager)this.connectionManagerConfig.build());
    private Configurer<? super PoolingHttpClientConnectionManagerBuilder> additionalConnectionManagerConfigurer = Configurer.notConfigured();
    private Configurer<? super HttpClientBuilder> additionalHttpClientConfigurer = Configurer.notConfigured();

    public ApacheHttpClientBuilderConfigurer connectionManager(Configurer<PoolingHttpClientConnectionManagerBuilder> connectionManagerConfigurer) {
        this.additionalConnectionManagerConfigurer = connectionManagerConfigurer;
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer socketTimeout(Duration duration) {
        this.configureSockets(SocketConfig.Builder::setSoTimeout, duration);
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer connectTimeout(Duration duration) {
        this.configureConnections(ConnectionConfig.Builder::setConnectTimeout, duration);
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer connectionRequestTimeout(Duration duration) {
        this.configureRequests(RequestConfig.Builder::setConnectionRequestTimeout, duration);
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer responseArrivalTimeout(Duration duration) {
        this.configureRequests(RequestConfig.Builder::setResponseTimeout, duration);
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer configure(Consumer<? super SocketConfig.Builder> socketConfig, Consumer<? super ConnectionConfig.Builder> connectionConfig, Consumer<? super RequestConfig.Builder> requestConfig) {
        socketConfig.accept((SocketConfig.Builder)this.socketConfig);
        connectionConfig.accept((ConnectionConfig.Builder)this.connectionConfig);
        requestConfig.accept((RequestConfig.Builder)this.requestConfig);
        return this;
    }

    @Override
    public ApacheHttpClientBuilderConfigurer configure(Consumer<? super HttpClientBuilder> httpClientCustomizer) {
        this.additionalHttpClientConfigurer = Configurer.of(httpClientCustomizer);
        return this;
    }

    @Override
    public void applyTo(HttpClientBuilder httpClientBuilder) {
        this.defaultConnectionManagerConfigurer.andThen(this.additionalConnectionManagerConfigurer).applyTo((PoolingHttpClientConnectionManagerBuilder)this.connectionManagerConfig);
        this.defaultRequestConfigurer.andThen(this.additionalHttpClientConfigurer).applyTo((HttpClientBuilder)httpClientBuilder);
    }
}

