/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import no.digipost.signature.client.core.internal.configuration.Configurer;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;

public final class ApacheHttpClientUserAgentConfigurer
implements Configurer<HttpClientBuilder> {
    private final List<String> userAgentParts;
    private final String delimiter;

    public ApacheHttpClientUserAgentConfigurer(String userAgentString) {
        this(Arrays.asList(userAgentString), " ");
    }

    public ApacheHttpClientUserAgentConfigurer(List<String> userAgentParts, String delimiter) {
        this.userAgentParts = new ArrayList<String>(userAgentParts);
        this.delimiter = delimiter;
    }

    public void append(String postfix) {
        this.userAgentParts.add(postfix);
    }

    @Override
    public void applyTo(HttpClientBuilder httpClientBuilder) {
        this.createUserAgentString().ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setUserAgent(arg_0));
    }

    public Optional<String> createUserAgentString() {
        if (this.userAgentParts.isEmpty()) {
            return Optional.empty();
        }
        Iterator<String> parts = this.userAgentParts.iterator();
        StringBuilder userAgent = new StringBuilder(parts.next());
        parts.forEachRemaining(part -> userAgent.append(this.delimiter).append((String)part));
        return Optional.of(userAgent.toString());
    }
}

