/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import no.digipost.signature.client.core.exceptions.UnexpectedResponseException;
import no.digipost.signature.client.core.internal.http.StatusCode;
import org.apache.hc.core5.http.HttpResponse;

public final class ResponseStatus {
    private final StatusCode statusCode;
    private final Predicate<StatusCode> statusExpectation;

    public static ResponseStatus fromHttpResponse(HttpResponse response) {
        return response != null ? ResponseStatus.fromHttpStatusCode(response.getCode()) : null;
    }

    public static ResponseStatus fromHttpStatusCode(int statusCode) {
        return new ResponseStatus(new StatusCode(statusCode), s -> true);
    }

    private ResponseStatus(StatusCode statusCode, Predicate<StatusCode> expectation) {
        this.statusCode = statusCode;
        this.statusExpectation = expectation;
    }

    public ResponseStatus expect(StatusCode.Family expectedStatusFamily) {
        return this.expect((? super StatusCode s) -> s.is(expectedStatusFamily));
    }

    public ResponseStatus expectOneOf(StatusCode.Family ... expectedStatusFamilies) {
        return this.expectOneOf(Stream.of(expectedStatusFamilies), (T family, StatusCode statusCode) -> statusCode.is((StatusCode.Family)((Object)family)));
    }

    private <T> ResponseStatus expectOneOf(Stream<T> expecteds, BiPredicate<T, StatusCode> expectedEvaluator) {
        Predicate<StatusCode> oneOfExpectedsAndAlsoExistingExpectation = expecteds.map(expected -> status -> expectedEvaluator.test((Object)expected, (StatusCode)status)).reduce(Predicate::or).map(this.statusExpectation::and).orElse(this.statusExpectation);
        return this.expect(oneOfExpectedsAndAlsoExistingExpectation);
    }

    public ResponseStatus expect(Predicate<? super StatusCode> expectation) {
        return new ResponseStatus(this.statusCode, this.statusExpectation.and(expectation));
    }

    public <X extends Exception> ResponseStatus throwIf(StatusCode statusCode, Function<StatusCode, X> exceptionSupplier) throws X {
        return this.throwIf((? super StatusCode s) -> s.equals(statusCode), exceptionSupplier);
    }

    public <X extends Exception> ResponseStatus throwIf(Predicate<? super StatusCode> illegalStatus, Function<StatusCode, X> exceptionSupplier) throws X {
        if (illegalStatus.test(this.statusCode)) {
            throw (Exception)exceptionSupplier.apply(this.statusCode);
        }
        return this;
    }

    public StatusCode get() {
        return this.orThrow(s -> new UnexpectedResponseException(this.statusCode));
    }

    public <X extends Exception> StatusCode orThrow(Function<StatusCode, X> exceptionSupplier) throws X {
        return this.throwIf(this.statusExpectation.negate(), exceptionSupplier).statusCode;
    }

    public String toString() {
        return this.statusCode.toString() + (this.statusExpectation.test(this.statusCode) ? "" : " (unexpected)");
    }
}

