/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.security.cert.X509Certificate;
import no.digipost.signature.client.core.exceptions.SecurityException;
import no.digipost.signature.client.security.CertificateChainValidation;
import org.apache.hc.core5.ssl.TrustStrategy;

public final class SignatureApiTrustStrategy
implements TrustStrategy {
    private final CertificateChainValidation certificateChainValidation;

    public SignatureApiTrustStrategy(CertificateChainValidation certificateChainValidation) {
        this.certificateChainValidation = certificateChainValidation;
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) {
        CertificateChainValidation.Result result = this.certificateChainValidation.validate(chain);
        switch (result) {
            case TRUSTED_AND_SKIP_FURTHER_VALIDATION: {
                return true;
            }
            case TRUSTED: {
                return false;
            }
        }
        String subjectDN = chain[0].getSubjectX500Principal().getName();
        throw new SecurityException("Untrusted server certificate, according to " + this.certificateChainValidation + ". Make sure the server URI is correct. Actual certificate: " + subjectDN + ". This could indicate a misconfiguration of the client or server, or potentially a man-in-the-middle attack.");
    }
}

