/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.UnaryOperator;
import no.digipost.signature.client.core.WithSignatureServiceRootUrl;
import org.apache.hc.core5.net.URIBuilder;

public final class SignatureServiceRoot {
    private final URI rootUrl;

    public static SignatureServiceRoot from(WithSignatureServiceRootUrl configuration) {
        return new SignatureServiceRoot(configuration.signatureServiceRootUrl());
    }

    public SignatureServiceRoot(URI rootUrl) {
        if (!rootUrl.isAbsolute()) {
            throw new IllegalArgumentException(rootUrl + " must be an absolute URL");
        }
        this.rootUrl = rootUrl;
    }

    public URI rootUrl() {
        return this.rootUrl;
    }

    public URI constructUrl(UnaryOperator<URIBuilder> uri) {
        URI serviceRoot = this.rootUrl();
        URIBuilder uriBuilder = (URIBuilder)uri.apply(new URIBuilder(serviceRoot));
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL constructed for service at " + serviceRoot + ": " + uriBuilder + ". Reason: " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }

    public String toString() {
        return "SignatureServiceRoot '" + this.rootUrl + "'";
    }
}

