/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public final class DigestUtils {
    public static byte[] digest(Algorithm algorithm, byte[] bytes) {
        return DigestUtils.getMessageDigest(algorithm).digest(bytes);
    }

    private static MessageDigest getMessageDigest(Algorithm algorithm) {
        try {
            return MessageDigest.getInstance(algorithm.algorithmName, algorithm.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException((Object)((Object)algorithm) + ": " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }

    public static enum Algorithm {
        SHA256("SHA-256"),
        SHA1("SHA-1");

        final String algorithmName;
        final Provider provider;

        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
            String providerSpec = "MessageDigest." + algorithmName;
            this.provider = Stream.of(Security.getProviders(providerSpec)).findFirst().orElseThrow(() -> new NoSuchElementException("java.security Provider for " + providerSpec));
        }

        public String toString() {
            return this.algorithmName + " provided by " + this.provider;
        }
    }
}

