/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.security.certificate_validator;

import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import no.digipost.signature.client.core.internal.security.certificate_validator.cert.BasicConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class X509 {
    private static final Logger LOG = LoggerFactory.getLogger(X509.class);
    private static final Pattern CN_PATTERN = Pattern.compile("CN=([0-9]{9})([^0-9].*)?$");
    private static final Pattern SERIALNUMBER_PATTERN = Pattern.compile("OID\\.2\\.5\\.4\\.5=([0-9]{9})", 2);
    private static final Pattern SEID2_PATTERN = Pattern.compile("OID\\.2\\.5\\.4\\.97=(?:NTRNO-)?([0-9]{9})", 2);

    public static final Optional<String> findOrganisasjonsnummer(X509Certificate certificate) {
        String subjectDnName = certificate.getSubjectX500Principal().getName("RFC1779");
        return X509.find(certificate, cert -> X509.tryFindOrgnr(subjectDnName, SEID2_PATTERN), cert -> X509.tryFindOrgnr(subjectDnName, SERIALNUMBER_PATTERN), cert -> X509.tryFindOrgnr(subjectDnName, CN_PATTERN)).findFirst();
    }

    @SafeVarargs
    public static final <R> Stream<R> find(X509Certificate certificate, Function<? super X509Certificate, ? extends Optional<R>> ... extractors) {
        return Stream.of(extractors).map(f -> (Optional)f.apply(certificate)).filter(Optional::isPresent).map(Optional::get);
    }

    public static final BasicConstraints getBasicConstraints(X509Certificate certificate) {
        return BasicConstraints.from(certificate);
    }

    private static final Optional<String> tryFindOrgnr(CharSequence text, Pattern extractPattern) {
        Optional<String> extracted = Optional.of(text).map(extractPattern::matcher).filter(Matcher::find).map(m -> m.group(1));
        if (!extracted.isPresent() && LOG.isTraceEnabled()) {
            LOG.trace("Orgnr ikke funnet i '{}' v.h.a. regex '{}'", (Object)text, (Object)extractPattern);
        }
        return extracted;
    }

    private X509() {
    }
}

