/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.security.certificate_validator.cert;

import java.security.cert.X509Certificate;
import java.util.Objects;

public final class BasicConstraints {
    public static final String OID = "2.5.29.19";
    public final Type type;
    public final int maxFollowingIntermediateCerts;

    public static BasicConstraints from(X509Certificate certificate) {
        if (certificate.getExtensionValue(OID) != null) {
            int pathLenConstraint = certificate.getBasicConstraints();
            return new BasicConstraints(pathLenConstraint >= 0 ? Type.CA : Type.NON_CA, pathLenConstraint);
        }
        return new BasicConstraints(Type.UNKNOWN, -1);
    }

    public BasicConstraints(Type type, int maxFollowingPathLength) {
        this.type = type;
        this.maxFollowingIntermediateCerts = maxFollowingPathLength;
    }

    public boolean equals(Object other) {
        if (other instanceof BasicConstraints) {
            BasicConstraints that = (BasicConstraints)other;
            if (this.type == Type.CA) {
                return this.type == that.type && this.maxFollowingIntermediateCerts == that.maxFollowingIntermediateCerts;
            }
            return this.type == that.type;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        if (this.type == Type.CA) {
            hash = 31 * hash + Integer.hashCode(this.maxFollowingIntermediateCerts);
        }
        hash = 31 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public String toString() {
        return "BasicConstraints OID 2.5.29.19: " + (Object)((Object)this.type) + ", maxFollowingIntermediateCerts: " + (this.type != Type.CA ? "(not applicable) " : "") + this.maxFollowingIntermediateCerts;
    }

    public static enum Type {
        CA,
        NON_CA,
        UNKNOWN;

    }
}

