/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLDirectSignerResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreateDirectManifest;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.ApiFlow;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.DownloadHelper;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.MaySpecifySender;
import no.digipost.signature.client.core.internal.http.SignatureServiceRoot;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectJobResponse;
import no.digipost.signature.client.direct.DirectJobStatusResponse;
import no.digipost.signature.client.direct.DirectSignerResponse;
import no.digipost.signature.client.direct.JaxbEntityMapping;
import no.digipost.signature.client.direct.StatusReference;
import no.digipost.signature.client.direct.WithSignerUrl;
import org.apache.hc.core5.http.ContentType;

public class DirectClient {
    private final ClientHelper client;
    private final DownloadHelper download;
    private final CreateASiCE<DirectJob> aSiCECreator;
    private final MaySpecifySender defaultSender;

    public DirectClient(ClientConfiguration config) {
        this.defaultSender = config.getDefaultSender();
        SignatureServiceRoot serviceRoot = SignatureServiceRoot.from(config);
        this.client = new ClientHelper(serviceRoot, config.defaultHttpClient());
        this.download = new DownloadHelper(serviceRoot, config.httpClientForDocumentDownloads());
        this.aSiCECreator = new CreateASiCE<DirectJob>(new CreateDirectManifest(this.defaultSender), config);
    }

    public DirectJobResponse create(DirectJob job) {
        Sender sender = job.resolveSenderWithFallbackTo(this.defaultSender, new MaySpecifySender[0]);
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLDirectSignatureJobRequest createJobRequest = JaxbEntityMapping.toJaxb(job, sender.getPollingQueue());
        XMLDirectSignatureJobResponse createdJob = this.client.sendSignatureJobRequest(ApiFlow.DIRECT, createJobRequest, documentBundle, sender);
        return JaxbEntityMapping.fromJaxb(createdJob);
    }

    public DirectSignerResponse requestNewRedirectUrl(WithSignerUrl request) {
        XMLDirectSignerResponse updatedSigner = this.client.requestNewRedirectUrl(request);
        return DirectSignerResponse.fromJaxb(updatedSigner);
    }

    public DirectJobStatusResponse getStatus(StatusReference statusReference) {
        XMLDirectSignatureJobStatusResponse xmlSignatureJobStatusResponse = this.client.sendSignatureJobStatusRequest(statusReference.getStatusUrl());
        return JaxbEntityMapping.fromJaxb(xmlSignatureJobStatusResponse, null);
    }

    public DirectJobStatusResponse getStatusChange() {
        return this.getStatusChange(null);
    }

    public DirectJobStatusResponse getStatusChange(Sender sender) {
        JobStatusResponse<XMLDirectSignatureJobStatusResponse> statusChangeResponse = this.client.getStatusChange(ApiFlow.DIRECT, MaySpecifySender.ofNullable(sender).resolveSenderWithFallbackTo(this.defaultSender, new MaySpecifySender[0]));
        if (statusChangeResponse.gotStatusChange()) {
            return JaxbEntityMapping.fromJaxb(statusChangeResponse.getStatusResponse(), statusChangeResponse.getNextPermittedPollTime());
        }
        return DirectJobStatusResponse.noUpdatedStatus(statusChangeResponse.getNextPermittedPollTime());
    }

    public void confirm(DirectJobStatusResponse receivedStatusResponse) {
        this.client.confirm(receivedStatusResponse);
    }

    public ResponseInputStream getXAdES(XAdESReference xAdESReference) {
        return this.download.getDataStream(xAdESReference.getxAdESUrl(), ContentType.APPLICATION_XML);
    }

    public ResponseInputStream getPAdES(PAdESReference pAdESReference) {
        return this.download.getDataStream(pAdESReference.getpAdESUrl(), ContentType.APPLICATION_OCTET_STREAM, ContentType.APPLICATION_XML);
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        this.client.deleteDocuments(deleteDocumentsUrl);
    }
}

