/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Objects;
import no.digipost.signature.client.core.DocumentType;

public class DirectDocument {
    public final String title;
    public final DocumentType type;
    public final byte[] content;

    public static Builder builder(String title, byte[] documentContent) {
        return new Builder(title, documentContent);
    }

    private DirectDocument(String title, DocumentType type, byte[] content) {
        this.title = title;
        this.type = type;
        this.content = content;
    }

    public static class Builder {
        private String title;
        private DocumentType type = DocumentType.PDF;
        private byte[] content;

        private Builder(String title, byte[] content) {
            this.title = Objects.requireNonNull(title, "title");
            this.content = Objects.requireNonNull(content, "document content");
        }

        public Builder type(DocumentType type) {
            this.type = Objects.requireNonNull(type, "document type");
            return this;
        }

        public DirectDocument build() {
            return new DirectDocument(this.title, this.type, this.content);
        }
    }
}

