/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.time.Instant;
import java.util.List;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.direct.DirectJobStatus;
import no.digipost.signature.client.direct.Signature;
import no.digipost.signature.client.direct.StatusRetrievalMethod;

public class DirectJobStatusResponse
implements Confirmable {
    private final Long signatureJobId;
    private final String reference;
    private final DirectJobStatus status;
    private final ConfirmationReference confirmationReference;
    private final DeleteDocumentsUrl deleteDocumentsUrl;
    private final List<Signature> signatures;
    private final PAdESReference pAdESReference;
    private final Instant nextPermittedPollTime;

    static DirectJobStatusResponse noUpdatedStatus(Instant nextPermittedPollTime) {
        return new DirectJobStatusResponse(null, null, DirectJobStatus.NO_CHANGES, null, null, null, null, nextPermittedPollTime){

            @Override
            public long getSignatureJobId() {
                throw new IllegalStateException("There were " + this + ", and querying the job ID is a programming error. Use the method is(" + DirectJobStatusResponse.class.getSimpleName() + "." + DirectJobStatus.NO_CHANGES.name() + ") to check if there were any status change before attempting to get any further information.");
            }

            @Override
            public String toString() {
                return "no direct jobs with updated status";
            }
        };
    }

    public DirectJobStatusResponse(Long signatureJobId, String reference, DirectJobStatus signatureJobStatus, ConfirmationReference confirmationUrl, DeleteDocumentsUrl deleteDocumentsUrl, List<Signature> signatures, PAdESReference pAdESReference, Instant nextPermittedPollTime) {
        this.signatureJobId = signatureJobId;
        this.reference = reference;
        this.status = signatureJobStatus;
        this.confirmationReference = confirmationUrl;
        this.deleteDocumentsUrl = deleteDocumentsUrl;
        this.signatures = signatures;
        this.pAdESReference = pAdESReference;
        this.nextPermittedPollTime = nextPermittedPollTime;
    }

    public long getSignatureJobId() {
        return this.signatureJobId;
    }

    public String getReference() {
        return this.reference;
    }

    public DirectJobStatus getStatus() {
        return this.status;
    }

    public boolean is(DirectJobStatus status) {
        return this.status == status;
    }

    public boolean isPAdESAvailable() {
        return this.pAdESReference != null;
    }

    public PAdESReference getpAdESUrl() {
        return this.pAdESReference;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public Signature getSignatureFrom(String signer) {
        return this.signatures.stream().filter(Signature.signatureFrom(signer)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find signature from this signer"));
    }

    public Instant getNextPermittedPollTime() {
        if (this.nextPermittedPollTime == null) {
            throw new IllegalStateException("Retrieving the next permitted poll time for " + this + " is a programming error. This is only allowed for jobs with status retrieval method set to '" + StatusRetrievalMethod.POLLING.name() + "'.");
        }
        return this.nextPermittedPollTime;
    }

    @Override
    public ConfirmationReference getConfirmationReference() {
        return this.confirmationReference;
    }

    public DeleteDocumentsUrl getDeleteDocumentsUrl() {
        return this.deleteDocumentsUrl;
    }

    public String toString() {
        return "status for direct job with ID " + this.signatureJobId + ": " + (Object)((Object)this.status);
    }
}

