/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import no.digipost.signature.api.xml.XMLDirectSignerStatusValue;

public final class SignerStatus {
    private static final ConcurrentMap<XMLDirectSignerStatusValue, SignerStatus> KNOWN = new ConcurrentHashMap<XMLDirectSignerStatusValue, SignerStatus>();
    public static final SignerStatus REJECTED = SignerStatus.of(XMLDirectSignerStatusValue.REJECTED);
    public static final SignerStatus EXPIRED = SignerStatus.of(XMLDirectSignerStatusValue.EXPIRED);
    public static final SignerStatus WAITING = SignerStatus.of(XMLDirectSignerStatusValue.WAITING);
    public static final SignerStatus SIGNED = SignerStatus.of(XMLDirectSignerStatusValue.SIGNED);
    public static final SignerStatus FAILED = SignerStatus.of(XMLDirectSignerStatusValue.FAILED);
    public static final SignerStatus NOT_APPLICABLE = SignerStatus.of(XMLDirectSignerStatusValue.NOT_APPLICABLE);
    public static final SignerStatus SIGNERS_NAME_NOT_AVAILABLE = SignerStatus.of(XMLDirectSignerStatusValue.SIGNERS_NAME_NOT_AVAILABLE);
    private final String identifier;

    static final SignerStatus of(XMLDirectSignerStatusValue status) {
        Objects.requireNonNull(status, XMLDirectSignerStatusValue.class.getSimpleName());
        return KNOWN.computeIfAbsent(status, key -> new SignerStatus(key.asString()));
    }

    private SignerStatus(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        return o instanceof SignerStatus && Objects.equals(this.identifier, ((SignerStatus)o).identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

