/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import no.digipost.signature.client.direct.DirectJobResponse;
import org.apache.hc.core5.net.URIBuilder;

public class StatusReference {
    public static final String STATUS_QUERY_TOKEN_PARAM_NAME = "status_query_token";
    private final URI statusUrl;
    private final String statusQueryToken;

    public static StatusUrlContruction of(DirectJobResponse response) {
        return StatusReference.ofUrl(response.getStatusUrl());
    }

    public static StatusUrlContruction ofUrl(final URI statusUrl) {
        return new StatusUrlContruction(){

            @Override
            public StatusReference withStatusQueryToken(String token) {
                return new StatusReference(statusUrl, token);
            }
        };
    }

    private StatusReference(URI statusUrl, String statusQueryToken) {
        this.statusUrl = statusUrl;
        this.statusQueryToken = Objects.requireNonNull(statusQueryToken, STATUS_QUERY_TOKEN_PARAM_NAME);
    }

    public URI getStatusUrl() {
        URIBuilder uriBuilder = new URIBuilder(this.statusUrl).addParameter(STATUS_QUERY_TOKEN_PARAM_NAME, this.statusQueryToken);
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to create valid URL from " + uriBuilder, e);
        }
    }

    public static abstract class StatusUrlContruction {
        private StatusUrlContruction() {
        }

        public abstract StatusReference withStatusQueryToken(String var1);
    }
}

