/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

public class Notifications {
    private String emailAddress = null;
    private String mobileNumber = null;

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public boolean shouldSendEmail() {
        return this.emailAddress != null;
    }

    public boolean shouldSendSms() {
        return this.mobileNumber != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        if (this.emailAddress != null && this.mobileNumber != null) {
            return "Notifications to " + this.emailAddress + " and " + this.mobileNumber;
        }
        if (this.emailAddress != null) {
            return "Notification to " + this.emailAddress;
        }
        if (this.mobileNumber != null) {
            return "Notification to " + this.mobileNumber;
        }
        return "No notifications";
    }

    public static class Builder {
        private final Notifications target = new Notifications();
        private boolean built = false;

        private Builder() {
        }

        public Builder withEmailTo(String emailAddress) {
            this.target.emailAddress = emailAddress;
            return this;
        }

        public Builder withSmsTo(String mobileNumber) {
            this.target.mobileNumber = mobileNumber;
            return this;
        }

        public Notifications build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            if (this.target.emailAddress == null && this.target.mobileNumber == null) {
                throw new IllegalStateException("At least one way of notifying the signer must be specified");
            }
            this.built = true;
            return this.target;
        }
    }
}

