/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreatePortalManifest;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.ApiFlow;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.DownloadHelper;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.MaySpecifySender;
import no.digipost.signature.client.core.internal.http.SignatureServiceRoot;
import no.digipost.signature.client.portal.JaxbEntityMapping;
import no.digipost.signature.client.portal.PortalJob;
import no.digipost.signature.client.portal.PortalJobResponse;
import no.digipost.signature.client.portal.PortalJobStatusChanged;
import org.apache.hc.core5.http.ContentType;

public class PortalClient {
    private final ClientHelper client;
    private final DownloadHelper download;
    private final CreateASiCE<PortalJob> aSiCECreator;
    private final MaySpecifySender defaultSender;

    public PortalClient(ClientConfiguration config) {
        this.defaultSender = config.getDefaultSender();
        SignatureServiceRoot serviceRoot = SignatureServiceRoot.from(config);
        this.client = new ClientHelper(serviceRoot, config.defaultHttpClient());
        this.download = new DownloadHelper(serviceRoot, config.httpClientForDocumentDownloads());
        this.aSiCECreator = new CreateASiCE<PortalJob>(new CreatePortalManifest(config.getDefaultSender(), config.getClock()), config);
    }

    public PortalJobResponse create(PortalJob job) {
        Sender sender = job.resolveSenderWithFallbackTo(this.defaultSender, new MaySpecifySender[0]);
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLPortalSignatureJobRequest createJobRequest = JaxbEntityMapping.toJaxb(job, sender.getPollingQueue());
        XMLPortalSignatureJobResponse createdJobResponse = this.client.sendSignatureJobRequest(ApiFlow.PORTAL, createJobRequest, documentBundle, sender);
        return JaxbEntityMapping.fromJaxb(createdJobResponse);
    }

    public PortalJobStatusChanged getStatusChange() {
        return this.getStatusChange(null);
    }

    public PortalJobStatusChanged getStatusChange(Sender sender) {
        JobStatusResponse<XMLPortalSignatureJobStatusChangeResponse> statusChangeResponse = this.client.getStatusChange(ApiFlow.PORTAL, MaySpecifySender.ofNullable(sender).resolveSenderWithFallbackTo(this.defaultSender, new MaySpecifySender[0]));
        if (statusChangeResponse.gotStatusChange()) {
            return JaxbEntityMapping.fromJaxb(statusChangeResponse);
        }
        return PortalJobStatusChanged.noUpdatedStatus(statusChangeResponse.getNextPermittedPollTime());
    }

    public void confirm(PortalJobStatusChanged receivedStatusChanged) {
        this.client.confirm(receivedStatusChanged);
    }

    public void cancel(Cancellable cancellable) {
        this.client.cancel(cancellable);
    }

    public ResponseInputStream getXAdES(XAdESReference xAdESReference) {
        return this.download.getDataStream(xAdESReference.getxAdESUrl(), ContentType.APPLICATION_XML);
    }

    public ResponseInputStream getPAdES(PAdESReference pAdESReference) {
        return this.download.getDataStream(pAdESReference.getpAdESUrl(), ContentType.APPLICATION_OCTET_STREAM, ContentType.APPLICATION_XML);
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        this.client.deleteDocuments(deleteDocumentsUrl);
    }
}

