/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.Objects;
import no.digipost.signature.client.core.DocumentType;

public class PortalDocument {
    public final String title;
    public final DocumentType type;
    public final byte[] content;

    public static Builder builder(String title, byte[] documentContent) {
        return new Builder(title, documentContent);
    }

    private PortalDocument(String title, DocumentType type, byte[] content) {
        this.title = title;
        this.type = type;
        this.content = content;
    }

    public static class Builder {
        private String title;
        private DocumentType type = DocumentType.PDF;
        private byte[] content;

        public Builder(String title, byte[] content) {
            this.title = Objects.requireNonNull(title, "title");
            this.content = Objects.requireNonNull(content, "document content");
        }

        public Builder type(DocumentType type) {
            this.type = Objects.requireNonNull(type, "document type");
            return this;
        }

        public PortalDocument build() {
            return new PortalDocument(this.title, this.type, this.content);
        }
    }
}

