/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.Document;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.internal.FileName;
import no.digipost.signature.client.core.internal.JobCustomizations;
import no.digipost.signature.client.portal.PortalDocument;
import no.digipost.signature.client.portal.PortalSigner;

public class PortalJob
implements SignatureJob {
    private final List<PortalDocument> documents;
    private final List<PortalSigner> signers;
    private final String title;
    private Optional<String> nonsensitiveTitle = Optional.empty();
    private Optional<String> description = Optional.empty();
    private String reference;
    private Optional<Instant> activationTime = Optional.empty();
    private Optional<Duration> available = Optional.empty();
    private Optional<Sender> sender = Optional.empty();
    private Optional<AuthenticationLevel> requiredAuthentication = Optional.empty();
    private Optional<IdentifierInSignedDocuments> identifierInSignedDocuments = Optional.empty();

    private PortalJob(String title, List<PortalDocument> documents, List<PortalSigner> signers) {
        this.title = title;
        this.documents = Collections.unmodifiableList(new ArrayList<PortalDocument>(documents));
        this.signers = Collections.unmodifiableList(new ArrayList<PortalSigner>(signers));
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public List<Document> getDocuments() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < this.documents.size(); ++i) {
            PortalDocument document = this.documents.get(i);
            documents.add(new Document(document.title, document.type.getMediaType(), String.format("%04d", i) + "_" + FileName.reduceToFileNameSafeChars(document.title) + "." + document.type.getFileExtension(), document.content));
        }
        return documents;
    }

    @Override
    public Optional<Sender> getSender() {
        return this.sender;
    }

    @Override
    public Optional<AuthenticationLevel> getRequiredAuthentication() {
        return this.requiredAuthentication;
    }

    @Override
    public Optional<IdentifierInSignedDocuments> getIdentifierInSignedDocuments() {
        return this.identifierInSignedDocuments;
    }

    public List<PortalSigner> getSigners() {
        return this.signers;
    }

    public Optional<Instant> getActivationTime() {
        return this.activationTime;
    }

    public Optional<Duration> getAvailable() {
        return this.available;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getNonsensitiveTitle() {
        return this.nonsensitiveTitle;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public static Builder builder(String title, PortalDocument document, PortalSigner signer) {
        return PortalJob.builder(title, Collections.singletonList(document), Collections.singletonList(signer));
    }

    public static Builder builder(String title, List<PortalDocument> documents, List<PortalSigner> signers) {
        return new Builder(title, documents, signers);
    }

    public static class Builder
    implements JobCustomizations<Builder> {
        private final PortalJob target;
        private boolean built = false;

        private Builder(String title, List<PortalDocument> documents, List<PortalSigner> signers) {
            this.target = new PortalJob(title, documents, signers);
        }

        @Override
        public Builder withReference(UUID uuid) {
            return this.withReference(uuid.toString());
        }

        @Override
        public Builder withReference(String reference) {
            this.target.reference = reference;
            return this;
        }

        @Override
        public Builder withSender(Sender sender) {
            this.target.sender = Optional.of(sender);
            return this;
        }

        @Override
        public Builder requireAuthentication(AuthenticationLevel minimumLevel) {
            this.target.requiredAuthentication = Optional.of(minimumLevel);
            return this;
        }

        @Override
        public Builder withIdentifierInSignedDocuments(IdentifierInSignedDocuments identifier) {
            this.target.identifierInSignedDocuments = Optional.of(identifier);
            return this;
        }

        public Builder withActivationTime(Instant activationTime) {
            this.target.activationTime = Optional.of(activationTime);
            return this;
        }

        public Builder availableFor(Duration duration) {
            this.target.available = Optional.of(duration);
            return this;
        }

        public Builder withNonsensitiveTitle(String nonsensitiveTitle) {
            this.target.nonsensitiveTitle = Optional.of(nonsensitiveTitle);
            return this;
        }

        public Builder withDescription(String description) {
            this.target.description = Optional.of(description);
            return this;
        }

        public PortalJob build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

