/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.time.Instant;
import java.util.List;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.portal.CancellationUrl;
import no.digipost.signature.client.portal.PortalJobStatus;
import no.digipost.signature.client.portal.Signature;
import no.digipost.signature.client.portal.SignerIdentifier;

public class PortalJobStatusChanged
implements Confirmable,
Cancellable {
    private final Long signatureJobId;
    private final String reference;
    private final PortalJobStatus status;
    private final DeleteDocumentsUrl deleteDocumentsUrl;
    private final PAdESReference pAdESReference;
    private final ConfirmationReference confirmationReference;
    private final CancellationUrl cancellationUrl;
    private final List<Signature> signatures;
    private final Instant nextPermittedPollTime;

    static PortalJobStatusChanged noUpdatedStatus(Instant nextPermittedPollTime) {
        return new PortalJobStatusChanged(null, null, PortalJobStatus.NO_CHANGES, null, null, null, null, null, nextPermittedPollTime){

            @Override
            public long getSignatureJobId() {
                throw new IllegalStateException("There were " + this + ", and querying the job ID is a programming error. Use the method is(" + PortalJobStatus.class.getSimpleName() + "." + PortalJobStatus.NO_CHANGES.name() + ") to check if there were any status change before attempting to get any further information.");
            }

            @Override
            public String toString() {
                return "no portal jobs with updated status";
            }
        };
    }

    PortalJobStatusChanged(Long signatureJobId, String reference, PortalJobStatus status, ConfirmationReference confirmationReference, CancellationUrl cancellationUrl, DeleteDocumentsUrl deleteDocumentsUrl, PAdESReference pAdESReference, List<Signature> signatures, Instant nextPermittedPollTime) {
        this.signatureJobId = signatureJobId;
        this.reference = reference;
        this.status = status;
        this.cancellationUrl = cancellationUrl;
        this.deleteDocumentsUrl = deleteDocumentsUrl;
        this.pAdESReference = pAdESReference;
        this.confirmationReference = confirmationReference;
        this.signatures = signatures;
        this.nextPermittedPollTime = nextPermittedPollTime;
    }

    public long getSignatureJobId() {
        return this.signatureJobId;
    }

    public String getReference() {
        return this.reference;
    }

    public PortalJobStatus getStatus() {
        return this.status;
    }

    public boolean is(PortalJobStatus status) {
        return this.status == status;
    }

    public boolean isPAdESAvailable() {
        return this.pAdESReference != null;
    }

    public PAdESReference getpAdESUrl() {
        return this.pAdESReference;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public Signature getSignatureFrom(SignerIdentifier signer) {
        return this.signatures.stream().filter(Signature.signatureFrom(signer)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find signature from this signer"));
    }

    public Instant getNextPermittedPollTime() {
        return this.nextPermittedPollTime;
    }

    @Override
    public ConfirmationReference getConfirmationReference() {
        return this.confirmationReference;
    }

    @Override
    public CancellationUrl getCancellationUrl() {
        return this.cancellationUrl;
    }

    public DeleteDocumentsUrl getDeleteDocumentsUrl() {
        return this.deleteDocumentsUrl;
    }

    public String toString() {
        return "updated status for portal job with id " + this.signatureJobId + ": " + (Object)((Object)this.status);
    }
}

