/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.time.Instant;
import java.util.function.Predicate;
import no.digipost.signature.api.xml.XMLNotifications;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.exceptions.SignatureException;
import no.digipost.signature.client.core.internal.PersonalIdentificationNumbers;
import no.digipost.signature.client.portal.SignatureStatus;
import no.digipost.signature.client.portal.SignerIdentifier;

public class Signature {
    private final Signer signer;
    private final SignatureStatus status;
    private final Instant statusDateTime;
    private final XAdESReference xAdESReference;

    public Signature(String personalIdentificationNumber, XMLNotifications identifier, SignatureStatus status, Instant statusDateTime, XAdESReference xAdESReference) {
        this.signer = new Signer(personalIdentificationNumber, identifier);
        this.status = status;
        this.xAdESReference = xAdESReference;
        this.statusDateTime = statusDateTime;
    }

    public String getSigner() {
        if (this.signer.hasPersonalIdentificationNumber()) {
            return this.signer.personalIdentificationNumber;
        }
        throw new SignatureException("Can't retrieve signers identified by contact information using this method. Use method PortalJobStatusChange.getSignatureFrom() instead.");
    }

    public SignatureStatus getStatus() {
        return this.status;
    }

    public boolean is(SignatureStatus status) {
        return this.status == status;
    }

    static Predicate<Signature> signatureFrom(SignerIdentifier signer) {
        return signature -> signature.signer.isSameAs(signer);
    }

    public Instant getStatusDateTime() {
        return this.statusDateTime;
    }

    public XAdESReference getxAdESUrl() {
        return this.xAdESReference;
    }

    public String toString() {
        return "Signature from " + this.signer + " with status '" + this.status + "' since " + this.statusDateTime + "" + (this.xAdESReference != null ? ". XAdES available at " + this.xAdESReference.getxAdESUrl() : "");
    }

    static class Signer {
        final String personalIdentificationNumber;
        String emailAddress;
        String mobileNumber;

        Signer(String personalIdentificationNumber, XMLNotifications identifier) {
            this.personalIdentificationNumber = personalIdentificationNumber;
            if (identifier != null) {
                if (identifier.getEmail() != null) {
                    this.emailAddress = identifier.getEmail().getAddress();
                }
                if (identifier.getSms() != null) {
                    this.mobileNumber = identifier.getSms().getNumber();
                }
            }
        }

        private static boolean isEqual(Object a, Object b) {
            return a == null && b == null || a != null && a.equals(b);
        }

        boolean isSameAs(SignerIdentifier other) {
            return Signer.isEqual(this.personalIdentificationNumber, other.personalIdentificationNumber) && Signer.isEqual(this.emailAddress, other.emailAddress) && Signer.isEqual(this.mobileNumber, other.mobileNumber);
        }

        boolean hasPersonalIdentificationNumber() {
            return this.personalIdentificationNumber != null;
        }

        public String toString() {
            if (this.personalIdentificationNumber != null) {
                return PersonalIdentificationNumbers.mask(this.personalIdentificationNumber);
            }
            if (this.emailAddress != null && this.mobileNumber == null) {
                return this.emailAddress;
            }
            if (this.emailAddress == null && this.mobileNumber != null) {
                return this.mobileNumber;
            }
            return this.emailAddress + " and " + this.mobileNumber;
        }
    }
}

