/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.security;

import java.security.cert.X509Certificate;
import no.digipost.signature.client.core.internal.security.certificate_validator.X509;
import no.digipost.signature.client.security.CertificateChainValidation;

public class OrganizationNumberValidation
implements CertificateChainValidation {
    private final String trustedOrganizationNumber;

    public OrganizationNumberValidation(String trustedOrganizationNumber) {
        this.trustedOrganizationNumber = trustedOrganizationNumber;
    }

    @Override
    public CertificateChainValidation.Result validate(X509Certificate[] certChain) {
        return X509.findOrganisasjonsnummer(certChain[0]).filter(this.trustedOrganizationNumber::equals).map(trusted -> CertificateChainValidation.Result.TRUSTED).orElse(CertificateChainValidation.Result.UNTRUSTED);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " trusting '" + this.trustedOrganizationNumber + "'";
    }
}

