/*
 * Decompiled with CFR 0.152.
 */
package no.finn.lambdacompanion;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Optionals {
    private Optionals() {
    }

    public static <T> Optional<T> firstOf(Supplier<Optional<T>> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).flatMap(Optionals::stream).findFirst();
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Optional<T> filter(Optional<?> opt, Class<T> cls) {
        return opt.filter(cls::isInstance);
    }

    public static Optional<String> ofBlankable(String blankable) {
        return Optional.ofNullable(blankable).filter(maybeEmpty -> !maybeEmpty.trim().isEmpty());
    }
}

