/*
 * Decompiled with CFR 0.152.
 */
package no.finn.lambdacompanion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import no.finn.lambdacompanion.Either;
import no.finn.lambdacompanion.Failure;
import no.finn.lambdacompanion.Functions;
import no.finn.lambdacompanion.Success;
import no.finn.lambdacompanion.ThrowingBiFunction;
import no.finn.lambdacompanion.ThrowingConsumer;
import no.finn.lambdacompanion.ThrowingFunction;
import no.finn.lambdacompanion.ThrowingSupplier;

public abstract class Try<T> {
    public abstract <U> Try<U> map(ThrowingFunction<? super T, ? extends U, ? extends Throwable> var1);

    public abstract <U> Try<U> flatMap(ThrowingFunction<? super T, ? extends Try<U>, ? extends Throwable> var1);

    public abstract Optional<Try<T>> filter(Predicate<T> var1);

    public abstract void forEach(ThrowingConsumer<? super T, ? extends Throwable> var1);

    public abstract Try<T> peek(ThrowingConsumer<? super T, ? extends Throwable> var1);

    public abstract Try<T> peekFailure(Consumer<Failure<T>> var1);

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <U> U recover(Function<? super T, ? extends U> var1, Function<Throwable, ? extends U> var2);

    public abstract Optional<T> toOptional();

    public abstract <X extends Throwable> Either<X, T> toEither();

    public abstract <X extends Throwable, Y extends Throwable> T orElseThrow(Function<X, Y> var1) throws Y;

    public abstract <E extends Throwable> T orElseRethrow() throws E;

    public static <U, V> Try<U> of(ThrowingFunction<V, ? extends U, ? extends Throwable> func, V v) {
        try {
            return new Success<U>(func.apply(v));
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U, V, W> Try<U> of(ThrowingBiFunction<V, W, ? extends U, ? extends Throwable> func, V v, W w) {
        try {
            return new Success<U>(func.apply(v, w));
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U> Try<U> of(ThrowingSupplier<U, ? extends Throwable> supplier) {
        try {
            return new Success<U>(supplier.get());
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U> Try<U> failure(Throwable throwable) {
        return new Failure(throwable);
    }

    public static <T> Try<List<T>> sequence(List<Try<T>> tries) {
        if (tries.size() == 0) {
            return Try.failure(new IllegalArgumentException("Cannot sequence an empty list"));
        }
        Try<List<List>> head = Functions.head(tries).map(Collections::singletonList);
        if (tries.size() == 1 || !head.toOptional().isPresent()) {
            return head;
        }
        return Try.concat(head, head.flatMap(t -> Try.sequence(Functions.tail(tries))));
    }

    private static <T> Try<List<T>> concat(Try<List<T>> head, Try<List<T>> tail) {
        return head.flatMap(l -> tail.map(k -> Try.concat(l, k)));
    }

    private static <T> List<T> concat(List<T> l, List<T> k) {
        ArrayList<T> retVal = new ArrayList<T>(l);
        retVal.addAll(k);
        return retVal;
    }
}

