/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import no.finn.unleash.EvaluatedToggle;
import no.finn.unleash.MoreOperations;
import no.finn.unleash.Unleash;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.Variant;
import no.finn.unleash.lang.Nullable;

public final class FakeUnleash
implements Unleash {
    private boolean enableAll = false;
    private boolean disableAll = false;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Variant> variants = new HashMap<String, Variant>();

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        if (this.enableAll) {
            return true;
        }
        if (this.disableAll) {
            return false;
        }
        return this.features.getOrDefault(toggleName, defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        return this.isEnabled(toggleName, fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        if (!this.features.containsKey(toggleName)) {
            return fallbackAction.apply(toggleName, UnleashContext.builder().build());
        }
        return this.isEnabled(toggleName);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        return this.getVariant(toggleName, defaultValue);
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        if (this.isEnabled(toggleName) && this.variants.containsKey(toggleName)) {
            return this.variants.get(toggleName);
        }
        return defaultValue;
    }

    @Override
    public List<String> getFeatureToggleNames() {
        return this.more().getFeatureToggleNames();
    }

    @Override
    public MoreOperations more() {
        return new FakeMore();
    }

    public void enableAll() {
        this.disableAll = false;
        this.enableAll = true;
        this.features.clear();
    }

    public void disableAll() {
        this.disableAll = true;
        this.enableAll = false;
        this.features.clear();
    }

    public void resetAll() {
        this.disableAll = false;
        this.enableAll = false;
        this.features.clear();
        this.variants.clear();
    }

    public void enable(String ... features) {
        for (String name : features) {
            this.features.put(name, true);
        }
    }

    public void disable(String ... features) {
        for (String name : features) {
            this.features.put(name, false);
        }
    }

    public void reset(String ... features) {
        for (String name : features) {
            this.features.remove(name);
        }
    }

    public void setVariant(String t1, Variant a) {
        this.variants.put(t1, a);
    }

    public class FakeMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return new ArrayList<String>(FakeUnleash.this.features.keySet());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(null);
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(@Nullable UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> new EvaluatedToggle((String)toggleName, FakeUnleash.this.isEnabled((String)toggleName), FakeUnleash.this.getVariant((String)toggleName))).collect(Collectors.toList());
        }

        @Override
        public void count(String toggleName, boolean enabled) {
        }

        @Override
        public void countVariant(String toggleName, String variantName) {
        }
    }
}

