/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.Objects;
import java.util.Optional;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.variant.Payload;

public class Variant {
    public static final Variant DISABLED_VARIANT = new Variant("disabled", (String)null, false);
    private final String name;
    @Nullable
    private final Payload payload;
    private final boolean enabled;

    public Variant(String name, @Nullable Payload payload, boolean enabled) {
        this.name = name;
        this.payload = payload;
        this.enabled = enabled;
    }

    public Variant(String name, @Nullable String payload, boolean enabled) {
        this.name = name;
        this.payload = new Payload("string", payload);
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Payload> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "Variant{name='" + this.name + '\'' + ", payload='" + this.payload + '\'' + ", enabled=" + this.enabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        return this.enabled == variant.enabled && Objects.equals(this.name, variant.name) && Objects.equals(this.payload, variant.payload);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.payload, this.enabled);
    }
}

