/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Pattern;
import no.finn.unleash.lang.Nullable;

public final class IpAddressMatcher {
    private static final Pattern SPLITTER = Pattern.compile("/");
    private final int nMaskBits;
    @Nullable
    private final InetAddress requiredAddress;

    public IpAddressMatcher(@Nullable String ipAddress) {
        String trimmedIpAddress;
        String string = trimmedIpAddress = ipAddress == null ? "" : ipAddress.trim();
        if (trimmedIpAddress.indexOf(47) > 0) {
            String[] addressAndMask = SPLITTER.split(trimmedIpAddress, -1);
            this.requiredAddress = this.parseAddress(addressAndMask[0]);
            this.nMaskBits = Integer.parseInt(addressAndMask[1]);
        } else {
            this.requiredAddress = this.parseAddress(trimmedIpAddress);
            this.nMaskBits = -1;
        }
    }

    public boolean matches(@Nullable String address) {
        if (address == null || address.isEmpty() || this.requiredAddress == null) {
            return false;
        }
        InetAddress remoteAddress = this.parseAddress(address);
        if (remoteAddress == null || !this.requiredAddress.getClass().equals(remoteAddress.getClass())) {
            return false;
        }
        if (this.nMaskBits < 0) {
            return remoteAddress.equals(this.requiredAddress);
        }
        byte[] remAddr = remoteAddress.getAddress();
        byte[] reqAddr = this.requiredAddress.getAddress();
        int oddBits = this.nMaskBits % 8;
        int nMaskBytes = this.nMaskBits / 8 + (oddBits == 0 ? 0 : 1);
        byte[] mask = new byte[nMaskBytes];
        Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
        if (oddBits != 0) {
            int finalByte = (1 << oddBits) - 1;
            mask[mask.length - 1] = (byte)(finalByte <<= 8 - oddBits);
        }
        for (int i = 0; i < mask.length; ++i) {
            if ((remAddr[i] & mask[i]) == (reqAddr[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private InetAddress parseAddress(@Nullable String address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to parse address " + address, e);
        }
    }
}

