/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.variant;

import java.util.Collections;
import java.util.List;
import no.finn.unleash.Variant;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.variant.Payload;
import no.finn.unleash.variant.VariantOverride;

public class VariantDefinition {
    private final String name;
    private final int weight;
    @Nullable
    private final Payload payload;
    @Nullable
    private final List<VariantOverride> overrides;

    public VariantDefinition(String name, int weight, @Nullable Payload payload, @Nullable List<VariantOverride> overrides) {
        this.name = name;
        this.weight = weight;
        this.payload = payload;
        this.overrides = overrides;
    }

    VariantDefinition(String name, int weight) {
        this(name, weight, null, Collections.emptyList());
    }

    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public Payload getPayload() {
        return this.payload;
    }

    List<VariantOverride> getOverrides() {
        if (this.overrides == null) {
            return Collections.emptyList();
        }
        return this.overrides;
    }

    Variant toVariant() {
        return new Variant(this.name, this.payload, true);
    }
}

