/*
 * Decompiled with CFR 0.152.
 */
package no.found.elasticsearch.transport.netty;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DownstreamMessageEvent;
import org.elasticsearch.common.netty.channel.LifeCycleAwareChannelHandler;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelHandler;
import org.elasticsearch.common.netty.util.Timeout;
import org.elasticsearch.common.netty.util.Timer;
import org.elasticsearch.common.netty.util.TimerTask;
import org.elasticsearch.common.unit.TimeValue;

public class ConnectionKeepAliveHandler
extends SimpleChannelHandler
implements LifeCycleAwareChannelHandler {
    private final Timer timer;
    private final TimeValue keepAliveInterval;
    private Timeout currentTimeout;
    ChannelBuffer keepAliveBuffer = ChannelBuffers.copiedBuffer((byte[])new byte[]{70, 75, 0, 0, 0, 0});
    private long lastWrite;

    public ConnectionKeepAliveHandler(Timer timer, TimeValue timeValue) {
        this.timer = timer;
        this.keepAliveInterval = timeValue;
    }

    private void addTimeoutTask(ChannelHandlerContext channelHandlerContext) {
        if (this.currentTimeout != null && !this.currentTimeout.isCancelled() && !this.currentTimeout.isExpired()) {
            this.currentTimeout.cancel();
        }
        this.currentTimeout = this.timer.newTimeout((TimerTask)new KeepAliveTimerTask(channelHandlerContext), 2L, TimeUnit.SECONDS);
    }

    public synchronized void writeRequested(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        super.writeRequested(channelHandlerContext, messageEvent);
        this.lastWrite = System.currentTimeMillis();
    }

    public void beforeAdd(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public synchronized void afterAdd(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.lastWrite = System.currentTimeMillis();
        this.addTimeoutTask(channelHandlerContext);
    }

    public void beforeRemove(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.currentTimeout != null && !this.currentTimeout.isCancelled() && !this.currentTimeout.isExpired()) {
            this.currentTimeout.cancel();
        }
    }

    private synchronized void send(ChannelHandlerContext channelHandlerContext, DownstreamMessageEvent downstreamMessageEvent) {
        long l = System.currentTimeMillis();
        if (l - this.lastWrite > this.keepAliveInterval.millis()) {
            this.lastWrite = l;
            channelHandlerContext.sendDownstream((ChannelEvent)downstreamMessageEvent);
        }
    }

    class KeepAliveTimerTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        public KeepAliveTimerTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled() || !this.ctx.getChannel().isConnected()) {
                return;
            }
            this.ctx.getPipeline().execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionKeepAliveHandler.this.send(KeepAliveTimerTask.this.ctx, new DownstreamMessageEvent(KeepAliveTimerTask.this.ctx.getChannel(), Channels.future((Channel)KeepAliveTimerTask.this.ctx.getChannel()), (Object)ConnectionKeepAliveHandler.this.keepAliveBuffer, KeepAliveTimerTask.this.ctx.getChannel().getRemoteAddress()));
                    ConnectionKeepAliveHandler.this.addTimeoutTask(KeepAliveTimerTask.this.ctx);
                }
            });
        }
    }
}

