/*
 * Decompiled with CFR 0.152.
 */
package no.found.elasticsearch.transport.netty;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import no.found.elasticsearch.transport.netty.ConnectionKeepAliveHandler;
import no.found.elasticsearch.transport.netty.FoundSSLUtils;
import no.found.elasticsearch.transport.netty.FoundTransportHeader;
import no.found.elasticsearch.transport.netty.ssl.FoundSSLHandler;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DownstreamMessageEvent;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelHandler;
import org.elasticsearch.common.netty.channel.UpstreamMessageEvent;
import org.elasticsearch.common.netty.util.Timer;
import org.elasticsearch.common.unit.TimeValue;

public class FoundSwitchingChannelHandler
extends SimpleChannelHandler {
    private final ESLogger logger;
    private final ChannelPipelineFactory originalFactory;
    private final ClusterName clusterName;
    private final String[] hostSuffixes;
    private final int[] sslPorts;
    private final String apiKey;
    private final Timer timer;
    private final TimeValue keepAliveInterval;
    private final boolean unsafeAllowSelfSigned;
    List<MessageEvent> pendingEvents = new ArrayList<MessageEvent>();
    ChannelBuffer buffered = ChannelBuffers.EMPTY_BUFFER;
    boolean isFoundCluster = false;

    public FoundSwitchingChannelHandler(ESLogger logger, ChannelPipelineFactory originalFactory, ClusterName clusterName, Timer timer, TimeValue keepAliveInterval, boolean unsafeAllowSelfSigned, String[] hostSuffixes, int[] sslPorts, String apiKey) {
        this.logger = logger;
        this.originalFactory = originalFactory;
        this.clusterName = clusterName;
        this.timer = timer;
        this.keepAliveInterval = keepAliveInterval;
        this.unsafeAllowSelfSigned = unsafeAllowSelfSigned;
        this.hostSuffixes = hostSuffixes;
        this.sslPorts = sslPorts;
        this.apiKey = apiKey;
    }

    public synchronized void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SocketAddress socketAddress = ctx.getChannel().getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            for (String suffix : this.hostSuffixes) {
                this.isFoundCluster = this.isFoundCluster || inetSocketAddress.getHostString().endsWith(suffix);
            }
            if (this.isFoundCluster) {
                for (int sslPort : this.sslPorts) {
                    if (inetSocketAddress.getPort() != sslPort) continue;
                    this.logger.info("Enabling SSL on transport layer with unsafeAllowSelfSigned=[{}].", new Object[]{this.unsafeAllowSelfSigned});
                    FoundSSLHandler handler = FoundSSLUtils.getSSLHandler(this.unsafeAllowSelfSigned, inetSocketAddress);
                    ctx.getPipeline().addFirst("ssl", (ChannelHandler)handler);
                    break;
                }
            }
        }
        super.channelBound(ctx, e);
    }

    public synchronized void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        if (this.isFoundCluster) {
            ctx.sendUpstream((ChannelEvent)e);
            this.logger.info("Authenticating with Found Elasticsearch at [{}]", new Object[]{ctx.getChannel().getRemoteAddress()});
            String remoteHostString = ((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getHostString();
            ChannelBuffer message = new FoundTransportHeader(this.clusterName.value(), this.apiKey).getHeaderBuffer();
            ctx.sendDownstream((ChannelEvent)new DownstreamMessageEvent(ctx.getChannel(), Channels.future((Channel)ctx.getChannel()), (Object)message, ctx.getChannel().getRemoteAddress()));
        }
    }

    public synchronized void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.pendingEvents.add(e);
    }

    public synchronized void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer newBuffer = (ChannelBuffer)e.getMessage();
            this.buffered = ChannelBuffers.copiedBuffer((ChannelBuffer[])new ChannelBuffer[]{this.buffered, newBuffer});
            if (this.buffered.readableBytes() < 8) {
                return;
            }
            int payloadLength = this.buffered.getInt(0);
            int revision = this.buffered.getInt(4);
            if (revision == 1) {
                if (this.buffered.readableBytes() < payloadLength + 4) {
                    return;
                }
                this.buffered.skipBytes(8);
                this.handleRevision1Response(ctx, payloadLength);
                for (MessageEvent event : this.pendingEvents) {
                    ctx.sendDownstream((ChannelEvent)event);
                }
                this.pendingEvents.clear();
            } else if (revision == -1) {
                if (this.buffered.readableBytes() < payloadLength + 4) {
                    return;
                }
                this.buffered.skipBytes(8);
                this.handleGenericResponse(ctx, payloadLength);
                for (MessageEvent event : this.pendingEvents) {
                    ctx.sendDownstream((ChannelEvent)event);
                }
                this.pendingEvents.clear();
            } else {
                this.handleUnknownRevisionResponse(ctx);
                this.pendingEvents.clear();
            }
        }
    }

    private void handleUnknownRevisionResponse(ChannelHandlerContext ctx) {
        this.logger.error("Unknown revision response received.", new Object[0]);
        ctx.getPipeline().remove((ChannelHandler)this);
        ctx.getChannel().close();
    }

    private void handleRevision1Response(ChannelHandlerContext ctx, int payloadLength) throws Exception {
        ChannelHandler handler;
        int code = this.buffered.readInt();
        int descriptionLength = this.buffered.readInt();
        byte[] descBytes = new byte[descriptionLength];
        this.buffered.readBytes(descBytes, 0, descBytes.length);
        String description = new String(descBytes, StandardCharsets.UTF_8);
        this.logger.debug("Decoded payload with length:[{}], code:[{}], descriptionLength:[{}], description:[{}]", new Object[]{payloadLength, code, descriptionLength, description});
        if (200 > code || code > 299) {
            this.logger.error("Unable to connect to Found Elasticsearch: [{}]: [{}]", new Object[]{code, description});
            ctx.getChannel().close();
            return;
        }
        this.logger.info("Connected to Found Elasticsearch: [{}]: [{}]", new Object[]{code, description});
        ctx.getPipeline().remove((ChannelHandler)this);
        ChannelPipeline pipeline = this.originalFactory.getPipeline();
        if (this.keepAliveInterval.millis() > 0L) {
            ctx.getPipeline().addLast("connection-keep-alive", (ChannelHandler)new ConnectionKeepAliveHandler(this.timer, this.keepAliveInterval));
        }
        while ((handler = pipeline.getFirst()) != null) {
            ChannelHandlerContext handlerContext = pipeline.getContext(handler);
            ctx.getPipeline().addLast(handlerContext.getName(), handler);
            pipeline.remove(handler);
        }
        ChannelBuffer remaining = this.buffered.slice();
        if (remaining.readableBytes() > 0) {
            ctx.sendUpstream((ChannelEvent)new UpstreamMessageEvent(ctx.getChannel(), (Object)remaining, ctx.getChannel().getRemoteAddress()));
        }
    }

    private void handleGenericResponse(ChannelHandlerContext ctx, int payloadLength) throws Exception {
        int code = this.buffered.readInt();
        int descriptionLength = this.buffered.readInt();
        byte[] descBytes = new byte[descriptionLength];
        this.buffered.readBytes(descBytes, 0, descBytes.length);
        String description = new String(descBytes, StandardCharsets.UTF_8);
        this.logger.error("Unable to connect to Found Elasticsearch: [{}]: [{}]", new Object[]{code, description});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!(e.getCause() instanceof ClosedChannelException)) {
            if (e.getCause() instanceof UnresolvedAddressException) {
                this.logger.error("Unable to resolve one of the server addresses: [{}]", new Object[]{e.getCause().getMessage()});
            } else if (e.getCause() instanceof ConnectException) {
                this.logger.error("Unable to connect: [{}]", new Object[]{e.getCause().getMessage()});
            } else if (e.getCause().getMessage() == null || !e.getCause().getMessage().contains("Connection reset by peer")) {
                super.exceptionCaught(ctx, e);
            }
        }
    }
}

