/*
 * Decompiled with CFR 0.152.
 */
package no.found.elasticsearch.transport.netty;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.Version;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class FoundTransportHeader {
    private final String clusterName;
    private final String apiKey;
    private static final int revisionLength = 4;
    private static final int revision = 1;
    private static final int versionLength = 4;

    public FoundTransportHeader(String clusterName, String apiKey) {
        this.clusterName = clusterName;
        this.apiKey = apiKey;
    }

    public ChannelBuffer getHeaderBuffer() throws IOException {
        byte[] clusterNameBytes = this.clusterName.getBytes(StandardCharsets.UTF_8);
        int clusterNameLength = clusterNameBytes.length;
        byte[] apiKeyBytes = this.apiKey.getBytes(StandardCharsets.UTF_8);
        int apiKeyLength = apiKeyBytes.length;
        ChannelBuffer headerPayload = ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{this.getIntBytes(4), this.getIntBytes(1), this.getIntBytes(4), this.getIntBytes(Version.CURRENT.id), this.getIntBytes(clusterNameLength), clusterNameBytes, this.getIntBytes(apiKeyLength), apiKeyBytes});
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{ChannelBuffers.wrappedBuffer((byte[])this.getIntBytes(headerPayload.readableBytes())), headerPayload});
    }

    protected byte[] getIntBytes(int i) throws IOException {
        byte[] bytes = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return bytes;
    }
}

