/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import no.found.elasticsearch.transport.netty.FoundSwitchingChannelHandler;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.bootstrap.ClientBootstrap;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.util.HashedWheelTimer;
import org.elasticsearch.common.netty.util.Timer;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty.NettyTransport;

public class FoundNettyTransport
extends NettyTransport {
    private final String[] hostSuffixes;
    private final int[] sslPorts;
    private final String apiKey;
    private final boolean unsafeAllowSelfSigned;
    private static final Timer timer = new HashedWheelTimer();
    private final TimeValue keepAliveInterval;
    private final ClusterName clusterName;

    @Inject
    public FoundNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, ClusterName clusterName, Version version) {
        super(settings, threadPool, networkService, version);
        this.clusterName = clusterName;
        this.keepAliveInterval = settings.getAsTime("transport.found.connection-keep-alive-interval", new TimeValue(20000L, TimeUnit.MILLISECONDS));
        this.unsafeAllowSelfSigned = settings.getAsBoolean("transport.found.ssl.unsafe_allow_self_signed", Boolean.valueOf(false));
        this.hostSuffixes = settings.getAsArray("transport.found.host-suffixes", new String[]{".foundcluster.com", ".found.no"});
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (String string : settings.getAsArray("transport.found.ssl-ports", new String[]{"9343"})) {
            try {
                linkedList.add(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.sslPorts = new int[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            this.sslPorts[i] = (Integer)linkedList.get(i);
        }
        this.apiKey = settings.get("transport.found.api-key", "missing-api-key");
    }

    void exceptionCaught(ChannelHandlerContext channelHandlerContext, ExceptionEvent exceptionEvent) throws Exception {
        if (exceptionEvent.getCause() instanceof SSLException) {
            return;
        }
        super.exceptionCaught(channelHandlerContext, exceptionEvent);
    }

    protected void doStart() throws ElasticsearchException {
        super.doStart();
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("clientBootstrap");
            field.setAccessible(true);
            ClientBootstrap clientBootstrap = (ClientBootstrap)field.get((Object)this);
            final ChannelPipelineFactory channelPipelineFactory = clientBootstrap.getPipelineFactory();
            clientBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new FoundSwitchingChannelHandler(FoundNettyTransport.this.logger, channelPipelineFactory, FoundNettyTransport.this.clusterName, timer, FoundNettyTransport.this.keepAliveInterval, FoundNettyTransport.this.unsafeAllowSelfSigned, FoundNettyTransport.this.hostSuffixes, FoundNettyTransport.this.sslPorts, FoundNettyTransport.this.apiKey)});
                }
            });
            field.setAccessible(false);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.logger.error("Unable to update the transport pipeline. Plugin upgrade required.", (Throwable)reflectiveOperationException, new Object[0]);
        }
    }

    protected void doStop() throws ElasticsearchException {
        super.doStop();
    }
}

