/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.callback.TokenCallback;
import no.nav.security.mock.extensions.NimbusExtensionsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013JF\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lno/nav/security/mock/oauth2/OAuth2TokenProvider;", "", "()V", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "rsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "accessToken", "Lcom/nimbusds/jwt/SignedJWT;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "nonce", "", "tokenCallback", "Lno/nav/security/mock/callback/TokenCallback;", "createSignedJWT", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "defaultClaims", "Lcom/nimbusds/jwt/JWTClaimsSet$Builder;", "subject", "audience", "additionalClaims", "", "expiry", "", "idToken", "onBehalfOfAccessToken", "publicJwkSet", "Companion", "mock-oauth2-server"})
public class OAuth2TokenProvider {
    private final JWKSet jwkSet = no.nav.security.mock.oauth2.OAuth2TokenProvider$Companion.access$generateJWKSet(Companion, "mock-oauth2-server-key");
    private final RSAKey rsaKey;
    private static final String DEFAULT_KEYID = "mock-oauth2-server-key";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JWKSet publicJwkSet() {
        JWKSet jWKSet = this.jwkSet.toPublicJWKSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)jWKSet, (String)"jwkSet.toPublicJWKSet()");
        return jWKSet;
    }

    @NotNull
    public final SignedJWT idToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @Nullable String nonce, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkParameterIsNotNull((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, tokenCallback.subject(tokenRequest), NimbusExtensionsKt.clientIdAsString(tokenRequest), nonce, tokenCallback.addClaims(tokenRequest), tokenCallback.tokenExpiry()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet, (String)"defaultClaims(\n         \u2026y()\n            ).build()");
        return this.createSignedJWT(jWTClaimsSet);
    }

    @NotNull
    public final SignedJWT accessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @Nullable String nonce, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkParameterIsNotNull((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, tokenCallback.subject(tokenRequest), tokenCallback.audience(tokenRequest), nonce, tokenCallback.addClaims(tokenRequest), tokenCallback.tokenExpiry()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet, (String)"defaultClaims(\n         \u2026y()\n            ).build()");
        return this.createSignedJWT(jWTClaimsSet);
    }

    @NotNull
    public final SignedJWT onBehalfOfAccessToken(@NotNull JWTClaimsSet claimsSet, @NotNull TokenRequest tokenRequest, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)claimsSet, (String)"claimsSet");
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        Instant now = Instant.now();
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder(claimsSet).expirationTime(Date.from(now.plusSeconds(tokenCallback.tokenExpiry()))).notBeforeTime(Date.from(now)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).audience(tokenCallback.audience(tokenRequest)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet, (String)"JWTClaimsSet.Builder(cla\u2026\n                .build()");
        return this.createSignedJWT(jWTClaimsSet);
    }

    @NotNull
    public final SignedJWT createSignedJWT(@NotNull JWTClaimsSet claimsSet) {
        Intrinsics.checkParameterIsNotNull((Object)claimsSet, (String)"claimsSet");
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.rsaKey.getKeyID()).type(JOSEObjectType.JWT);
        SignedJWT signedJWT = new SignedJWT(header.build(), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.rsaKey.toPrivateKey());
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    private final JWTClaimsSet.Builder defaultClaims(HttpUrl issuerUrl, String subject, String audience, String nonce, Map<String, ? extends Object> additionalClaims, long expiry) {
        Instant now = Instant.now();
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder().subject(subject).audience(audience).issuer(issuerUrl.toString()).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry))).jwtID(UUID.randomUUID().toString());
        if (nonce != null) {
            jwtClaimsSetBuilder.claim("nonce", (Object)nonce);
        }
        Map<String, ? extends Object> $this$forEach$iv = additionalClaims;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl2 = false;
            jwtClaimsSetBuilder.claim(it.getKey(), it.getValue());
        }
        JWTClaimsSet.Builder builder = jwtClaimsSetBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"jwtClaimsSetBuilder");
        return builder;
    }

    public OAuth2TokenProvider() {
        JWK jWK = this.jwkSet.getKeyByKeyId(DEFAULT_KEYID);
        if (jWK == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.nimbusds.jose.jwk.RSAKey");
        }
        this.rsaKey = (RSAKey)jWK;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lno/nav/security/mock/oauth2/OAuth2TokenProvider$Companion;", "", "()V", "DEFAULT_KEYID", "", "createJWK", "Lcom/nimbusds/jose/jwk/RSAKey;", "keyID", "keyPair", "Ljava/security/KeyPair;", "generateJWKSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "keyId", "generateKeyPair", "mock-oauth2-server"})
    public static final class Companion {
        private final JWKSet generateJWKSet(String keyId) {
            return new JWKSet((JWK)this.createJWK(keyId, this.generateKeyPair()));
        }

        private final KeyPair generateKeyPair() {
            KeyPair keyPair;
            try {
                KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
                gen.initialize(2048);
                KeyPair keyPair2 = gen.generateKeyPair();
                Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"gen.generateKeyPair()");
                keyPair = keyPair2;
            }
            catch (NoSuchAlgorithmException e) {
                throw (Throwable)new RuntimeException(e);
            }
            return keyPair;
        }

        private final RSAKey createJWK(String keyID, KeyPair keyPair) {
            PublicKey publicKey = keyPair.getPublic();
            if (publicKey == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            PrivateKey privateKey = keyPair.getPrivate();
            if (privateKey == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
            }
            RSAKey rSAKey = new RSAKey.Builder((RSAPublicKey)publicKey).privateKey((RSAPrivateKey)privateKey).keyID(keyID).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)rSAKey, (String)"RSAKey.Builder(keyPair.p\u2026\n                .build()");
            return rSAKey;
        }

        private Companion() {
        }

        public static final /* synthetic */ JWKSet access$generateJWKSet(Companion $this, String keyId) {
            return $this.generateJWKSet(keyId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

