/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.callback.TokenCallback;
import no.nav.security.mock.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lno/nav/security/mock/oauth2/grant/JwtBearerGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/OAuth2TokenProvider;", "(Lno/nav/security/mock/oauth2/OAuth2TokenProvider;)V", "assertion", "Lcom/nimbusds/jwt/JWTClaimsSet;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "tokenResponse", "Lno/nav/security/mock/oauth2/OAuth2TokenResponse;", "issuerUrl", "Lokhttp3/HttpUrl;", "tokenCallback", "Lno/nav/security/mock/callback/TokenCallback;", "verifyAssertion", "", "mock-oauth2-server"})
public final class JwtBearerGrantHandler
implements GrantHandler {
    private final OAuth2TokenProvider tokenProvider;

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkParameterIsNotNull((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        JWTClaimsSet receivedClaimsSet = this.assertion(tokenRequest);
        SignedJWT accessToken = this.tokenProvider.onBehalfOfAccessToken(receivedClaimsSet, tokenRequest, tokenCallback);
        return new OAuth2TokenResponse("Bearer", null, accessToken.serialize(), UUID.randomUUID().toString(), NimbusExtensionsKt.expiresIn(accessToken), tokenRequest.getScope().toString());
    }

    private final JWTClaimsSet assertion(TokenRequest tokenRequest) {
        JWTBearerGrant jWTBearerGrant;
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (!(authorizationGrant instanceof JWTBearerGrant)) {
            authorizationGrant = null;
        }
        if ((jWTBearerGrant = (JWTBearerGrant)authorizationGrant) == null || (jWTBearerGrant = jWTBearerGrant.getJWTAssertion()) == null || (jWTBearerGrant = jWTBearerGrant.getJWTClaimsSet()) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter assertion");
        }
        return jWTBearerGrant;
    }

    private final JWTClaimsSet verifyAssertion(HttpUrl issuerUrl, String assertion) {
        JWTClaimsSet jWTClaimsSet;
        ConfigurableJWTProcessor jwtProcessor = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
        jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("at+jwt")}));
        JWSKeySelector keySelector = (JWSKeySelector)new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)new ImmutableJWKSet(this.tokenProvider.publicJwkSet()));
        jwtProcessor.setJWSKeySelector(keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuerUrl.toString()).build(), (Set)new HashSet(CollectionsKt.listOf((Object[])new String[]{"sub", "iat", "exp", "aud"}))));
        try {
            JWTClaimsSet jWTClaimsSet2 = jwtProcessor.process(assertion, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet2, (String)"jwtProcessor.process(assertion, null)");
            jWTClaimsSet = jWTClaimsSet2;
        }
        catch (Exception e) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "invalid assertion.", e);
        }
        return jWTClaimsSet;
    }

    public JwtBearerGrantHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkParameterIsNotNull((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
    }
}

