/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.login;

import java.io.File;
import java.io.FileNotFoundException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.templates.TemplateMapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "", "templateMapper", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/templates/TemplateMapper;Lno/nav/security/mock/oauth2/OAuth2Config;)V", "loginHtml", "", "httpRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "loginSubmit", "Lno/nav/security/mock/oauth2/login/Login;", "mock-oauth2-server"})
public final class LoginRequestHandler {
    @NotNull
    private final TemplateMapper templateMapper;
    @NotNull
    private final OAuth2Config config;

    public LoginRequestHandler(@NotNull TemplateMapper templateMapper2, @NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)templateMapper2, (String)"templateMapper");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.templateMapper = templateMapper2;
        this.config = config;
    }

    @NotNull
    public final String loginHtml(@NotNull OAuth2HttpRequest httpRequest) {
        String string;
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        String string2 = this.config.getLoginPagePath();
        if (string2 == null) {
            string = null;
        } else {
            String string3;
            String it = string2;
            boolean bl = false;
            try {
                string3 = FilesKt.readText$default((File)new File(it), null, (int)1, null);
            }
            catch (FileNotFoundException e) {
                OAuth2ExceptionKt.notFound("The configured loginPagePath '" + this.config.getLoginPagePath() + "' is invalid, please ensure that it points to a valid html file");
                throw new KotlinNothingValueException();
            }
            string = string3;
        }
        String string4 = string;
        return string4 == null ? this.templateMapper.loginHtml(httpRequest) : string4;
    }

    @NotNull
    public final Login loginSubmit(@NotNull OAuth2HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        OAuth2HttpRequest.Parameters formParameters = httpRequest.getFormParameters();
        String string = formParameters.get("username");
        if (string == null) {
            OAuth2ExceptionKt.missingParameter("username");
            throw new KotlinNothingValueException();
        }
        String username = string;
        return new Login(username, formParameters.get("claims"));
    }
}

