/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.introspect;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.introspect.IntrospectKt;
import no.nav.security.mock.oauth2.introspect.IntrospectResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"log", "Lmu/KLogger;", "auth", "", "method", "authenticated", "", "Lokhttp3/Headers;", "introspect", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "verifyToken", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nIntrospect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Introspect.kt\nno/nav/security/mock/oauth2/introspect/IntrospectKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class IntrospectKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @NotNull
    public static final Route.Builder introspect(@NotNull Route.Builder $this$introspect, @NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$introspect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        return $this$introspect.post("/introspect", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(tokenProvider){
            final /* synthetic */ OAuth2TokenProvider $tokenProvider;
            {
                this.$tokenProvider = $tokenProvider;
                super(1);
            }

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest request) {
                Object object;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                        IntrospectKt.access$getLog$p().debug("received request to introspect endpoint, returning active and claims from token");
                        if (!IntrospectKt.access$authenticated(request.getHeaders())) {
                            String msg = "The client authentication was invalid";
                            throw new OAuth2Exception(OAuth2Error.INVALID_CLIENT.setDescription(msg), msg);
                        }
                        object = IntrospectKt.access$verifyToken(request, this.$tokenProvider);
                        if (object == null) break block4;
                        JWTClaimsSet it = object;
                        boolean bl = false;
                        Map claims = it.getClaims();
                        V v = claims.get("exp");
                        Long l = v instanceof Long ? (Long)v : null;
                        v = claims.get("iat");
                        Long l2 = v instanceof Long ? (Long)v : null;
                        v = claims.get("nbf");
                        OAuth2HttpResponse oAuth2HttpResponse = OAuth2HttpResponseKt.json(new IntrospectResponse(true, String.valueOf(claims.get("scope")), String.valueOf(claims.get("client_id")), String.valueOf(claims.get("username")), String.valueOf(claims.get("token_type")), l, l2, v instanceof Long ? (Long)v : null, String.valueOf(claims.get("sub")), String.valueOf(claims.get("aud")), String.valueOf(claims.get("iss")), String.valueOf(claims.get("jti"))));
                        object = oAuth2HttpResponse;
                        if (oAuth2HttpResponse != null) break block5;
                    }
                    object = OAuth2HttpResponseKt.json(new IntrospectResponse(false, null, null, null, null, null, null, null, null, null, null, null, 4094, null));
                }
                return object;
            }
        }));
    }

    private static final JWTClaimsSet verifyToken(OAuth2HttpRequest $this$verifyToken, OAuth2TokenProvider tokenProvider) {
        JWTClaimsSet jWTClaimsSet;
        String tokenString = $this$verifyToken.getFormParameters().get("token");
        HttpUrl issuer = HttpUrlExtensionsKt.toIssuerUrl($this$verifyToken.getUrl());
        JWKSet jwkSet = tokenProvider.publicJwkSet(HttpUrlExtensionsKt.issuerId(issuer));
        JWSAlgorithm algorithm = tokenProvider.getAlgorithm();
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)tokenString);
            Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"parse(...)");
            jWTClaimsSet = NimbusExtensionsKt.verifySignatureAndIssuer(signedJWT, new Issuer(issuer.toString()), jwkSet, algorithm);
        }
        catch (Exception e) {
            log.debug("token_introspection: failed signature validation");
            return null;
        }
        return jWTClaimsSet;
    }

    private static final boolean authenticated(Headers $this$authenticated) {
        boolean bl;
        String string = $this$authenticated.get("Authorization");
        if (string != null) {
            String authHeader = string;
            boolean bl2 = false;
            String string2 = IntrospectKt.auth(authHeader, "Bearer ");
            if (string2 != null) {
                bl = ((CharSequence)string2).length() > 0;
            } else {
                String string3 = IntrospectKt.auth(authHeader, "Basic ");
                bl = string3 != null ? ((CharSequence)string3).length() > 0 : false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String auth(String $this$auth, String method) {
        Object object = new String[]{method};
        Object it = object = StringsKt.split$default((CharSequence)$this$auth, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = it.size() == 2 ? object : null;
        return object2 != null ? (String)CollectionsKt.last((List)object2) : null;
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ boolean access$authenticated(Headers $receiver) {
        return IntrospectKt.authenticated($receiver);
    }

    public static final /* synthetic */ JWTClaimsSet access$verifyToken(OAuth2HttpRequest $receiver, OAuth2TokenProvider tokenProvider) {
        return IntrospectKt.verifyToken($receiver, tokenProvider);
    }
}

