/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;

public class JwtTokenClaims {
    private final JWTClaimsSet jwtClaimsSet;

    public JwtTokenClaims(JWTClaimsSet jwtClaimsSet) {
        this.jwtClaimsSet = jwtClaimsSet;
    }

    public Object get(String name) {
        return this.getClaimSet().getClaim(name);
    }

    public String getStringClaim(String name) {
        try {
            return this.getClaimSet().getStringClaim(name);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIssuer() {
        return this.getClaimSet().getIssuer();
    }

    public Date getExpirationTime() {
        return this.getClaimSet().getExpirationTime();
    }

    public String getSubject() {
        return this.getClaimSet().getSubject();
    }

    public List<String> getAsList(String name) {
        try {
            return this.getClaimSet().getStringListClaim(name);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsClaim(String name, String value) {
        Object claim = this.getClaimSet().getClaim(name);
        if (claim == null) {
            return false;
        }
        if (claim instanceof String) {
            String claimAsString = (String)claim;
            return claimAsString.equals(value);
        }
        if (claim instanceof JSONArray) {
            JSONArray claimasList = (JSONArray)claim;
            return claimasList.contains((Object)value);
        }
        return false;
    }

    public Map<String, Object> getAllClaims() {
        return this.getClaimSet().getClaims();
    }

    JWTClaimsSet getClaimSet() {
        return this.jwtClaimsSet;
    }
}

