/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;

public class TokenValidationContext {
    private final Map<String, JwtToken> issuerShortNameValidatedTokenMap;

    public TokenValidationContext(Map<String, JwtToken> issuerShortNameValidatedTokenMap) {
        this.issuerShortNameValidatedTokenMap = issuerShortNameValidatedTokenMap;
    }

    public Optional<JwtToken> getJwtTokenAsOptional(String issuerName) {
        return this.jwtToken(issuerName);
    }

    public Optional<JwtToken> getFirstValidToken() {
        return this.issuerShortNameValidatedTokenMap.values().stream().findFirst();
    }

    public JwtToken getJwtToken(String issuerName) {
        return this.jwtToken(issuerName).orElse(null);
    }

    public JwtTokenClaims getClaims(String issuerName) {
        return this.jwtToken(issuerName).map(JwtToken::getJwtTokenClaims).orElse(null);
    }

    public Optional<JwtTokenClaims> getAnyValidClaims() {
        return this.issuerShortNameValidatedTokenMap.values().stream().map(JwtToken::getJwtTokenClaims).findFirst();
    }

    public boolean hasValidToken() {
        return !this.issuerShortNameValidatedTokenMap.isEmpty();
    }

    public boolean hasTokenFor(String issuerName) {
        return this.jwtToken(issuerName).isPresent();
    }

    public List<String> getIssuers() {
        return new ArrayList<String>(this.issuerShortNameValidatedTokenMap.keySet());
    }

    private Optional<JwtToken> jwtToken(String issuerName) {
        return this.issuerShortNameValidatedTokenMap.containsKey(issuerName) ? Optional.of(this.issuerShortNameValidatedTokenMap.get(issuerName)) : Optional.empty();
    }
}

