/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0002\u001f B_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerProperties;", "", "discoveryUrl", "Ljava/net/URL;", "acceptedAudience", "", "", "cookieName", "headerName", "validation", "Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation;", "jwksCache", "Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache;", "proxyUrl", "usePlaintextForHttps", "", "(Ljava/net/URL;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation;Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache;Ljava/net/URL;Z)V", "getAcceptedAudience", "()Ljava/util/List;", "getDiscoveryUrl", "()Ljava/net/URL;", "getHeaderName", "()Ljava/lang/String;", "getJwksCache", "()Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache;", "getProxyUrl", "getUsePlaintextForHttps", "()Z", "getValidation", "()Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation;", "toString", "JwksCache", "Validation", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nIssuerProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssuerProperties.kt\nno/nav/security/token/support/core/configuration/IssuerProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class IssuerProperties {
    @NotNull
    private final URL discoveryUrl;
    @NotNull
    private final List<String> acceptedAudience;
    @NotNull
    private final String headerName;
    @NotNull
    private final Validation validation;
    @NotNull
    private final JwksCache jwksCache;
    @Nullable
    private final URL proxyUrl;
    private final boolean usePlaintextForHttps;

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName, @NotNull String headerName, @NotNull Validation validation, @NotNull JwksCache jwksCache, @Nullable URL proxyUrl, boolean usePlaintextForHttps) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        Intrinsics.checkNotNullParameter((Object)jwksCache, (String)"jwksCache");
        this.discoveryUrl = discoveryUrl;
        this.acceptedAudience = acceptedAudience;
        this.headerName = headerName;
        this.validation = validation;
        this.jwksCache = jwksCache;
        this.proxyUrl = proxyUrl;
        this.usePlaintextForHttps = usePlaintextForHttps;
        String string = cookieName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            throw new IllegalArgumentException("Cookie-support is discontinued, please remove " + it + " from your configuration now");
        }
    }

    public /* synthetic */ IssuerProperties(URL uRL, List list, String string, String string2, Validation validation, JwksCache jwksCache, URL uRL2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = "Authorization";
        }
        if ((n & 0x10) != 0) {
            validation = Validation.EMPTY;
        }
        if ((n & 0x20) != 0) {
            jwksCache = JwksCache.EMPTY_CACHE;
        }
        if ((n & 0x40) != 0) {
            uRL2 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(uRL, list, string, string2, validation, jwksCache, uRL2, bl);
    }

    @NotNull
    public final URL getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    @NotNull
    public final List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    @NotNull
    public final String getHeaderName() {
        return this.headerName;
    }

    @NotNull
    public final Validation getValidation() {
        return this.validation;
    }

    @NotNull
    public final JwksCache getJwksCache() {
        return this.jwksCache;
    }

    @Nullable
    public final URL getProxyUrl() {
        return this.proxyUrl;
    }

    public final boolean getUsePlaintextForHttps() {
        return this.usePlaintextForHttps;
    }

    @NotNull
    public String toString() {
        return "IssuerProperties(discoveryUrl=" + this.discoveryUrl + ", acceptedAudience=" + this.acceptedAudience + ", headerName=" + this.headerName + ", proxyUrl=" + this.proxyUrl + ", usePlaintextForHttps=" + this.usePlaintextForHttps + ", validation=" + this.validation + ", jwksCache=" + this.jwksCache + ")";
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName, @NotNull String headerName, @NotNull Validation validation, @NotNull JwksCache jwksCache, @Nullable URL proxyUrl) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        Intrinsics.checkNotNullParameter((Object)jwksCache, (String)"jwksCache");
        this(discoveryUrl, acceptedAudience, cookieName, headerName, validation, jwksCache, proxyUrl, false, 128, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName, @NotNull String headerName, @NotNull Validation validation, @NotNull JwksCache jwksCache) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        Intrinsics.checkNotNullParameter((Object)jwksCache, (String)"jwksCache");
        this(discoveryUrl, acceptedAudience, cookieName, headerName, validation, jwksCache, null, false, 192, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName, @NotNull String headerName, @NotNull Validation validation) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        this(discoveryUrl, acceptedAudience, cookieName, headerName, validation, null, null, false, 224, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName, @NotNull String headerName) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        this(discoveryUrl, acceptedAudience, cookieName, headerName, null, null, null, false, 240, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience, @Nullable String cookieName) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        this(discoveryUrl, acceptedAudience, cookieName, null, null, null, null, false, 248, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl, @NotNull List<String> acceptedAudience) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        Intrinsics.checkNotNullParameter(acceptedAudience, (String)"acceptedAudience");
        this(discoveryUrl, acceptedAudience, null, null, null, null, null, false, 252, null);
    }

    @JvmOverloads
    public IssuerProperties(@NotNull URL discoveryUrl) {
        Intrinsics.checkNotNullParameter((Object)discoveryUrl, (String)"discoveryUrl");
        this(discoveryUrl, null, null, null, null, null, null, false, 254, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache;", "", "lifespan", "", "refreshTime", "(Ljava/lang/Long;Ljava/lang/Long;)V", "isConfigured", "", "()Z", "getLifespan", "()Ljava/lang/Long;", "Ljava/lang/Long;", "lifespanMillis", "getLifespanMillis", "()J", "getRefreshTime", "refreshTimeMillis", "getRefreshTimeMillis", "equals", "other", "hashCode", "", "toString", "", "Companion", "token-validation-core"})
    public static final class JwksCache {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Long lifespan;
        @Nullable
        private final Long refreshTime;
        private final boolean isConfigured;
        private final long lifespanMillis;
        private final long refreshTimeMillis;
        @JvmField
        @NotNull
        public static final JwksCache EMPTY_CACHE = new JwksCache(15L, 5L);

        public JwksCache(@Nullable Long lifespan, @Nullable Long refreshTime) {
            this.lifespan = lifespan;
            this.refreshTime = refreshTime;
            this.isConfigured = this.lifespan != null && this.refreshTime != null;
            Long l = this.lifespan;
            Intrinsics.checkNotNull((Object)l);
            this.lifespanMillis = TimeUnit.MINUTES.toMillis(l);
            Long l2 = this.refreshTime;
            Intrinsics.checkNotNull((Object)l2);
            this.refreshTimeMillis = TimeUnit.MINUTES.toMillis(l2);
        }

        @Nullable
        public final Long getLifespan() {
            return this.lifespan;
        }

        @Nullable
        public final Long getRefreshTime() {
            return this.refreshTime;
        }

        public final boolean isConfigured() {
            return this.isConfigured;
        }

        public final long getLifespanMillis() {
            return this.lifespanMillis;
        }

        public final long getRefreshTimeMillis() {
            return this.refreshTimeMillis;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            JwksCache jwksCache = (JwksCache)other;
            return Intrinsics.areEqual((Object)this.lifespan, (Object)jwksCache.lifespan) && Intrinsics.areEqual((Object)this.refreshTime, (Object)jwksCache.refreshTime);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.lifespan, this.refreshTime};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + " [lifespan=" + this.lifespan + ",refreshTime=" + this.refreshTime + "]";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache$Companion;", "", "()V", "EMPTY_CACHE", "Lno/nav/security/token/support/core/configuration/IssuerProperties$JwksCache;", "token-validation-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation;", "", "optionalClaims", "", "", "(Ljava/util/List;)V", "isConfigured", "", "()Z", "getOptionalClaims", "()Ljava/util/List;", "equals", "other", "hashCode", "", "toString", "Companion", "token-validation-core"})
    public static final class Validation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> optionalClaims;
        private final boolean isConfigured;
        @JvmField
        @NotNull
        public static final Validation EMPTY = new Validation(CollectionsKt.emptyList());

        public Validation(@NotNull List<String> optionalClaims) {
            Intrinsics.checkNotNullParameter(optionalClaims, (String)"optionalClaims");
            this.optionalClaims = optionalClaims;
            this.isConfigured = !((Collection)this.optionalClaims).isEmpty();
        }

        public /* synthetic */ Validation(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<String> getOptionalClaims() {
            return this.optionalClaims;
        }

        public final boolean isConfigured() {
            return this.isConfigured;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            Validation that = (Validation)other;
            return Intrinsics.areEqual(this.optionalClaims, that.optionalClaims);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.optionalClaims};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return "IssuerProperties.Validation(optionalClaims=" + this.optionalClaims + ")";
        }

        public Validation() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation$Companion;", "", "()V", "EMPTY", "Lno/nav/security/token/support/core/configuration/IssuerProperties$Validation;", "token-validation-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

