/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.utils;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000e"}, d2={"Lno/nav/security/token/support/core/utils/JwtTokenUtil;", "", "()V", "context", "Lno/nav/security/token/support/core/context/TokenValidationContext;", "holder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "contextHasValidToken", "", "getJwtToken", "Ljava/util/Optional;", "Lno/nav/security/token/support/core/jwt/JwtToken;", "issuer", "", "token-validation-core"})
public final class JwtTokenUtil {
    @NotNull
    public static final JwtTokenUtil INSTANCE = new JwtTokenUtil();

    private JwtTokenUtil() {
    }

    @JvmStatic
    public static final boolean contextHasValidToken(@Nullable TokenValidationContextHolder holder) {
        return INSTANCE.context(holder).hasValidToken();
    }

    @JvmStatic
    @NotNull
    public static final Optional<JwtToken> getJwtToken(@NotNull String issuer, @Nullable TokenValidationContextHolder holder) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        return INSTANCE.context(holder).getJwtTokenAsOptional(issuer);
    }

    private final TokenValidationContext context(TokenValidationContextHolder holder) {
        Object object = holder;
        if (object == null || (object = object.getTokenValidationContext()) == null) {
            throw new IllegalStateException("TokenValidationContextHolder is null");
        }
        return object;
    }
}

